![Trailer](https://github.com/tburrows13/ModuleInserterSimplified/raw/master/resources/trailer.mp4)

# Module Inserter Simplified

Click the shortcut button or press `Alt + M` to get the module inserter. Select a module from the pop-up interface or use `Shift + Scroll` to cycle between modules:

![Selection interface](https://assets-mod.factorio.com/assets/9f61ae97849b25b22600b0d6ba8e7d58dd4f0156.png)
![Cycle modules](https://github.com/tburrows13/ModuleInserterSimplified/raw/master/resources/cycle-modules.mp4)

Click and drag the mouse to fill the selected machines with modules:

![Fill all with modules](https://github.com/tburrows13/ModuleInserterSimplified/raw/master/resources/insert-all.mp4)

Right-click and drag the mouse to insert a single module into each machine:

![Add single module to all](https://github.com/tburrows13/ModuleInserterSimplified/raw/master/resources/insert-single.mp4)

Shift-click and drag the mouse to clear module requests.
Shift-right-click and drag the mouse to remove one module request from each machine.
Use _Remove modules_ to remove all modules with left-click, and one module per machine with right-click.

Right clicking on modules in the selection interface can be used to remove modules from the cycle that aren't being used.
Modules will be automatically enabled when unlocked.

When a module request is completed, the modules in that machine will be sorted.

-----
## Information
The original [Module Inserter](https://mods.factorio.com/mod/ModuleInserter) is a powerful tool for inserting custom configurations of modules into machines. However, I didn't like having to create and save different configurations for every type of module and having to add each building type individually to each configuration. [Module Inserter Extended](https://mods.factorio.com/mod/ModuleInserterEx) helps with the second problem, but still, I thought I could come up with totally new, and much easier to use solution...

_Module Inserter Simplified_ is very simple and doesn't have configurations to set up beforehand. For 99% of usecases it will be much more straightforward. Using right-click and drag (insert single module) it is possible to request any combination of modules, but you may prefer to still use Module Inserter (Extended) for this. Module Inserter Simplified is a completely separate mod so there's no problems having both in the same save.

Works in multiplayer and compatible with any mod. Tested for compatibility with [Space Exploration](https://mods.factorio.com/mod/space-exploration), [Krastorio2](https://mods.factorio.com/mod/Krastorio2), [Bob's Modules](https://mods.factorio.com/mod/bobmodules), [Pyanodons](https://mods.factorio.com/user/pyanodon), and [Nullius](https://mods.factorio.com/mod/nullius).

-----
## Recommendations
- Review the above instructions in-game using _Tips and tricks_
- Remove `Shift + Scroll` zoom keybinds in _Controls_ settings to stop it interfering with module cycling
- Fully integrated with [Ghost Warnings](https://mods.factorio.com/mod/GhostWarnings)

---
## Translation

You can help by translating this mod into your language using [CrowdIn](https://crowdin.com/project/factorio-mods-localization). Any translations made will be included in the next release.
