local data_util = require("__flib__.data-util")

data:extend({
  {
    type = "custom-input",
    name = "tl-get-tool",
    key_sequence = "ALT + M",
    action = "spawn-item",
    item_to_spawn = "tl-tool",
    order = "a",
  },
  {
    type = "custom-input",
    name = "tl-edit-tape",
    key_sequence = "mouse-button-2",
    order = "b",
  },
  {
    type = "custom-input",
    name = "tl-delete-tape",
    key_sequence = "SHIFT + mouse-button-2",
    order = "c",
  },
  {
    type = "custom-input",
    name = "tl-increase-divisor",
    key_sequence = "ALT + mouse-wheel-up",
    order = "d",
  },
  {
    type = "custom-input",
    name = "tl-decrease-divisor",
    key_sequence = "ALT + mouse-wheel-down",
    order = "e",
  },
  {
    type = "custom-input",
    name = "tl-next-mode",
    key_sequence = "CONTROL + mouse-wheel-up",
    order = "f",
  },
  {
    type = "custom-input",
    name = "tl-previous-mode",
    key_sequence = "CONTROL + mouse-wheel-down",
    order = "g",
  },
  {
    type = "custom-input",
    name = "tl-linked-clear-cursor",
    key_sequence = "",
    linked_game_control = "clear-cursor",
  },
  {
    type = "collision-layer",
    name = "tapeline",
  },
  {
    type = "simple-entity-with-force",
    name = "tl-dummy-entity",
    flags = { "not-on-map", "player-creation" },
    hidden = true,
    collision_box = { { -0.4, -0.4 }, { 0.4, 0.4 } },
    collision_mask = { layers = { tapeline = true } },
    selectable_in_game = false,
    build_sound = { filename = "__core__/sound/silence-1sec.ogg" },
    created_smoke = { smoke_name = "tl-empty-smoke" }, --- @diagnostic disable-line
    alert_when_damaged = false,
  },
  {
    type = "highlight-box",
    name = "tl-highlight-box",
  },
  {
    type = "selection-tool",
    name = "tl-tool",
    localised_name = { "item-name.tl-tool" },
    icons = {
      { icon = data_util.black_image, icon_size = 1, scale = 64 },
      { icon = "__Tapeline__/graphics/item/tapeline-tool.png", icon_size = 32, icon_mipmaps = 2 },
    },
    subgroup = "tool",
    order = "c[automated-construction]-x",
    select = {
      mode = "nothing",
      border_color = { a = 0 },
      cursor_box_type = "not-allowed",
    },
    alt_select = {
      mode = "nothing",
      border_color = { a = 0 },
      cursor_box_type = "not-allowed",
    },
    place_result = "tl-dummy-entity",
    stack_size = 10,
    flags = { "only-in-cursor", "spawnable" },
    hidden = true,
    draw_label_for_cursor_render = true,
    mouse_cursor = "tl-tool-cursor",
  },
  {
    type = "mouse-cursor",
    name = "tl-tool-cursor",
    filename = "__Tapeline__/graphics/cursor/draw-cursor.png",
    hot_pixel_x = 1,
    hot_pixel_y = 1,
  },
  {
    type = "shortcut",
    name = "tl-get-tool",
    order = "a[alt-mode]-b[copy]",
    associated_control_input = "tl-get-tool",
    action = "spawn-item",
    item_to_spawn = "tl-tool",
    icon = "__Tapeline__/graphics/shortcut/shortcut-x56.png",
    icon_size = 56,
    small_icon = "__Tapeline__/graphics/shortcut/shortcut-x24.png",
    small_icon_size = 24,
  },
  {
    type = "tips-and-tricks-item-category",
    name = "tapeline",
    order = "l-[tapeline]",
  },
  {
    type = "tips-and-tricks-item",
    name = "tl-introduction",
    category = "tapeline",
    order = "a",
    is_title = true,
    image = "__Tapeline__/graphics/tips-and-tricks/introduction.png",
  },
  {
    type = "tips-and-tricks-item",
    name = "tl-persistent",
    category = "tapeline",
    order = "b",
    indent = 1,
    dependencies = { "tl-introduction" },
    trigger = { type = "dependencies-met" },
    image = "__Tapeline__/graphics/tips-and-tricks/persistent.png",
  },
  {
    type = "tips-and-tricks-item",
    name = "tl-modes",
    category = "tapeline",
    order = "c",
    indent = 1,
    dependencies = { "tl-introduction" },
    trigger = { type = "dependencies-met" },
    image = "__Tapeline__/graphics/tips-and-tricks/modes.png",
  },
  {
    type = "tips-and-tricks-item",
    name = "tl-divisors",
    category = "tapeline",
    order = "d",
    indent = 1,
    dependencies = { "tl-introduction" },
    trigger = { type = "dependencies-met" },
    image = "__Tapeline__/graphics/tips-and-tricks/divisors.png",
  },
  {
    type = "tips-and-tricks-item",
    name = "tl-edit",
    category = "tapeline",
    order = "e",
    indent = 1,
    dependencies = { "tl-introduction" },
    trigger = { type = "dependencies-met" },
    image = "__Tapeline__/graphics/tips-and-tricks/edit.png",
  },
  {
    type = "trivial-smoke",
    name = "tl-empty-smoke",
    animation = {
      filename = data_util.empty_image,
      size = { 1, 1 },
      frame_count = 8,
    },
    duration = 1,
  },
})
