local utils = require("scripts/utils") --[[@as BlueprintShotgun.utils]]
local render = require("scripts/render") --[[@as BlueprintShotgun.render]]
local cmu = require("collision-mask-util")

---@class BlueprintShotgun.tile-ghosts
local lib = {}

---@param params BlueprintShotgun.HandlerParams
function lib.process(params)
    if params.ammo_limit == 0 then return end

    local surface = params.surface
    local ghosts = utils.find_entities_in_radius(surface, {
        type = "tile-ghost",
        position = params.target_pos,
        radius = params.radius,
        force = params.character.force,
    })
    table.sort(ghosts, utils.distance_sort(params.target_pos))
    utils.arc_cull(ghosts, params.character.position, params.target_pos)

    local used = false

    for _, ghost in pairs(ghosts) do
        if storage.to_build[ghost.unit_number] then goto continue end

        local item = ghost.ghost_prototype.items_to_place_this[1]
        local prototype = prototypes.item[item.name]
        local tile_result = prototype.place_as_tile_result --[[@as PlaceAsTileResult]]
        local mask = tile_result.condition

        local tile = surface.get_tile(ghost.position) ---@diagnostic disable-line
        if cmu.masks_collide(mask, tile.prototype.collision_mask) ~= tile_result.invert then goto continue end

        local count, quality = utils.get_item_count_aq(params.inventory, item.name)
        if count < item.count then
            goto continue
        end

        local slot = game.create_inventory(1)
        local stack = params.inventory.find_item_stack{name = item.name, quality = quality} ---@cast stack LuaItemStack
        slot[1].transfer_stack(stack, item.count) -- possible dupe bug with manual inventory sorting when count > 1 but I do not care

        local sprite, shadow = render.draw_new_item(surface, item.name, params.source_pos)
        local duration = utils.get_flying_item_duration(params.source_pos, ghost.position)
        storage.flying_items[sprite.id] = {
            action = "tile",
            slot = slot,
            surface = surface,
            force = params.character.force,
            source_pos = params.source_pos,
            target_pos = ghost.position,
            start_tick = params.tick,
            end_tick = params.tick + duration,
            orientation_deviation = utils.orientation_deviaiton(),
            sprite = sprite,
            shadow = shadow,
            target_entity = ghost,
            unit_number = ghost.unit_number,
        } --[[@as FlyingTileItem]]

        storage.to_build[ghost.unit_number] = true

        used = true
        params.ammo_item.drain_ammo(0.25)
        params.ammo_limit = params.ammo_limit - 1
        if params.ammo_limit <= 0 then break end

        ::continue::
    end

    return used
end

---@param item FlyingTileItem
function lib.action(item)
    local target_entity = item.target_entity --[[@as LuaEntity]]
    if target_entity.valid then
        local surface = item.surface
        local position = target_entity.position
        ---@diagnostic disable-next-line: missing-parameter, param-type-mismatch
        local prototype = surface.get_tile(position).prototype
        if not prototype.allows_being_covered then
            utils.spill_products(surface, position, prototype, item.force)
        end
        target_entity.revive{raise_revive = true}
        ---@diagnostic disable-next-line: missing-parameter, param-type-mismatch
        local new_tile = surface.get_tile(position)
        if new_tile.hidden_tile ~= prototype.name then
            utils.spill_products(surface, position, prototype, item.force)
        end
    else
        utils.spill_item(item)
    end
    storage.to_build[item.unit_number] = nil
end

return lib

---@class FlyingTileItem:FlyingItemBase
---@field action "tile"
---@field target_entity LuaEntity
---@field unit_number uint