/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.perception.common.mixin.trails.entity;

import it.hurts.octostudios.perception.common.mixin.trails.entity.EntityMixin;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={FireworkRocketEntity.class})
public abstract class FireworkRocketEntityMixin
extends EntityMixin {
    @Shadow
    public abstract ItemStack m_7846_();

    @Override
    public int getTrailFadeInColor() {
        FireworkRocketEntity entity = (FireworkRocketEntity)this;
        ItemStack stack = this.m_7846_();
        if (stack.m_41619_()) {
            return -1;
        }
        CompoundTag tag = stack.m_41737_("Fireworks");
        if (tag == null) {
            return -1;
        }
        ListTag explosions = tag.m_128437_("Explosions", 10);
        int maxSize = explosions.size();
        if (maxSize == 0) {
            return -1;
        }
        ArrayList<Integer> colors = new ArrayList<Integer>();
        for (int i = 0; i < maxSize; ++i) {
            int[] explosionColors;
            CompoundTag explosion = explosions.m_128728_(i);
            for (int color : explosionColors = explosion.m_128465_("Colors")) {
                colors.add(color);
            }
        }
        int count = colors.size();
        if (count == 0) {
            return -1;
        }
        if (count < 2) {
            return (Integer)colors.get(0) & 0xFFFFFF | 0xFF000000;
        }
        int totalTime = count * 3;
        int tick = entity.f_19797_ % totalTime;
        float t = (float)tick / (float)totalTime * (float)count;
        int index = (int)Math.floor(t) % count;
        float fraction = t - (float)((int)t);
        Integer color1 = (Integer)colors.get(index);
        Integer color2 = (Integer)colors.get((index + 1) % count);
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * fraction);
        int g = (int)((float)g1 + (float)(g2 - g1) * fraction);
        int b = (int)((float)b1 + (float)(b2 - b1) * fraction);
        return r << 16 | g << 8 | b | 0xFF000000;
    }
}

