/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import mod.crend.autohud.render.ComponentRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AutoHudGui
extends ForgeGui {
    public static final Map<ResourceLocation, ComponentRenderer> COMPONENT_RENDERERS = new HashMap<ResourceLocation, ComponentRenderer>();

    public AutoHudGui() {
        super(Minecraft.m_91087_());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void preHudComponent(RenderGuiOverlayEvent.Pre event) {
        Optional.ofNullable(COMPONENT_RENDERERS.get(event.getOverlay().id())).ifPresent(wrapper -> {
            if (wrapper.isActive() && !wrapper.doRender()) {
                event.setCanceled(true);
            }
            wrapper.beginRender(event.getGuiGraphics());
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void cancelHudComponent(RenderGuiOverlayEvent.Pre event) {
        if (event.isCanceled()) {
            Optional.ofNullable(COMPONENT_RENDERERS.get(event.getOverlay().id())).ifPresent(wrapper -> wrapper.endRender(event.getGuiGraphics()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void postHudComponent(RenderGuiOverlayEvent.Post event) {
        Optional.ofNullable(COMPONENT_RENDERERS.get(event.getOverlay().id())).ifPresent(wrapper -> wrapper.endRender(event.getGuiGraphics()));
    }

    static {
        COMPONENT_RENDERERS.put(VanillaGuiOverlay.PLAYER_HEALTH.id(), ComponentRenderer.HEALTH);
        COMPONENT_RENDERERS.put(VanillaGuiOverlay.ARMOR_LEVEL.id(), ComponentRenderer.ARMOR);
        COMPONENT_RENDERERS.put(VanillaGuiOverlay.FOOD_LEVEL.id(), ComponentRenderer.HUNGER);
        COMPONENT_RENDERERS.put(VanillaGuiOverlay.AIR_LEVEL.id(), ComponentRenderer.AIR);
        COMPONENT_RENDERERS.put(VanillaGuiOverlay.MOUNT_HEALTH.id(), ComponentRenderer.MOUNT_HEALTH);
        COMPONENT_RENDERERS.put(VanillaGuiOverlay.JUMP_BAR.id(), ComponentRenderer.MOUNT_JUMP_BAR);
        COMPONENT_RENDERERS.put(VanillaGuiOverlay.EXPERIENCE_BAR.id(), ComponentRenderer.EXPERIENCE_BAR_FORGE);
        COMPONENT_RENDERERS.put(VanillaGuiOverlay.SCOREBOARD.id(), ComponentRenderer.SCOREBOARD);
        COMPONENT_RENDERERS.put(VanillaGuiOverlay.HOTBAR.id(), ComponentRenderer.HOTBAR);
        COMPONENT_RENDERERS.put(VanillaGuiOverlay.ITEM_NAME.id(), ComponentRenderer.TOOLTIP);
        COMPONENT_RENDERERS.put(VanillaGuiOverlay.CHAT_PANEL.id(), ComponentRenderer.CHAT);
        COMPONENT_RENDERERS.put(VanillaGuiOverlay.TITLE_TEXT.id(), ComponentRenderer.ACTION_BAR);
        COMPONENT_RENDERERS.put(VanillaGuiOverlay.BOSS_EVENT_PROGRESS.id(), ComponentRenderer.BOSS_BAR);
    }
}

