/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud;

import mod.crend.autohud.AutoHud;
import mod.crend.autohud.AutoHudCompat;
import mod.crend.autohud.AutoHudGui;
import mod.crend.autohud.ModKeyBindings;
import mod.crend.autohud.api.AutoHudApi;
import mod.crend.autohud.config.ConfigHandler;
import mod.crend.autohud.render.AutoHudRenderer;
import mod.crend.libbamboo.ConfigScreen;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;

@Mod(value="autohud")
public class AutoHudMod {
    public AutoHudMod() {
        AutoHud.loadConfig();
        ConfigScreen.register((ModLoadingContext)ModLoadingContext.get(), () -> ConfigHandler.CONFIG_STORE);
    }

    @Mod.EventBusSubscriber(modid="autohud", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ModBus {
        @SubscribeEvent
        static void onClientSetup(FMLClientSetupEvent event) {
            AutoHud.init();
            MinecraftForge.EVENT_BUS.register((Object)new AutoHudGui());
            MinecraftForge.EVENT_BUS.addListener(ModBus::onClientTick);
            AutoHudCompat.registerCompatibilityProviders();
        }

        @SubscribeEvent
        static void onInterModProcess(InterModProcessEvent event) {
            InterModComms.getMessages((String)"autohud", "register_api"::equals).map(msg -> (AutoHudApi)msg.messageSupplier().get()).forEach(AutoHud::addApi);
        }

        @SubscribeEvent
        static void onKeyMappingsRegister(RegisterKeyMappingsEvent event) {
            ModKeyBindings.ALL.forEach(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
        }

        @SubscribeEvent
        static void onRegisterOverlaysEvent(RegisterGuiOverlaysEvent event) {
            event.registerAboveAll(AutoHud.CHAT_INDICATOR.m_135815_(), (forgeGui, context, f, i, j) -> AutoHudRenderer.renderChatMessageIndicator(context, f));
        }

        static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                return;
            }
            ModKeyBindings.clientTick(Minecraft.m_91087_());
        }
    }
}

