/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.compat.legendarysurvivaloverhaul;

import java.util.Objects;
import mod.crend.autohud.compat.legendarysurvivaloverhaul.LSOComponents;
import mod.crend.autohud.component.state.ComponentState;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureEnum;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.temperature.TemperatureCapability;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.wetness.WetnessCapability;
import sfiomn.legendarysurvivaloverhaul.util.CapabilityUtil;

public class TemperatureState
extends ComponentState {
    LocalPlayer player;
    TemperatureCapability TEMPERATURE_CAP;
    WetnessCapability WETNESS_CAP;
    TemperatureEnum oldTemperature;
    int oldWetness;

    public TemperatureState(LocalPlayer player) {
        super(LSOComponents.TEMPERATURE, true);
        this.player = player;
        this.TEMPERATURE_CAP = CapabilityUtil.getTempCapability((Player)player);
        this.WETNESS_CAP = CapabilityUtil.getWetnessCapability((Player)player);
    }

    @Override
    public void update() {
        int newWetness;
        TemperatureEnum newTemperature = this.TEMPERATURE_CAP.getTemperatureEnum();
        if (this.doReveal(newTemperature, newWetness = this.WETNESS_CAP.getWetness())) {
            this.component.revealCombined();
        }
        this.oldTemperature = newTemperature;
        this.oldWetness = newWetness;
    }

    protected boolean doReveal(TemperatureEnum newTemperature, int newWetness) {
        return !this.component.config.active() || !Objects.equals(newTemperature, this.oldTemperature) || this.oldWetness != newWetness || newWetness > 0 || this.forceReveal();
    }

    private boolean forceReveal() {
        return switch (this.TEMPERATURE_CAP.getTemperatureEnum()) {
            default -> throw new IncompatibleClassChangeError();
            case TemperatureEnum.FROSTBITE, TemperatureEnum.HEAT_STROKE -> true;
            case TemperatureEnum.COLD, TemperatureEnum.NORMAL, TemperatureEnum.HOT -> false;
        };
    }
}

