/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.crend.autohud.AutoHud;
import mod.crend.autohud.component.Components;
import mod.crend.autohud.component.Hud;
import mod.crend.autohud.component.state.ComponentState;
import mod.crend.autohud.config.ConfigHandler;
import mod.crend.autohud.config.ScrollDirection;
import mod.crend.autohud.render.ComponentRenderer;
import mod.crend.libbamboo.VersionUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;

public class Component {
    private static final List<Component> mainHudComponents = new ArrayList<Component>();
    private static final Map<MobEffect, Component> statusEffectComponents = new HashMap<MobEffect, Component>();
    private static final List<Component> components = new ArrayList<Component>();
    public final ConfigHandler.IComponent config;
    public ComponentState state = null;
    private final Function<LocalPlayer, ComponentState> stateProvider;
    private final List<Component> stackComponents;
    public double alpha = 1.0;
    public double alphaDelta = 0.0;
    public double offset = 0.0;
    public double offsetDelta = 0.0;
    public final ResourceLocation identifier;
    private final Supplier<Boolean> isTargeted;
    private final boolean inMainHud;
    private float visibleTime = 1.0f;

    public static void registerComponent(Component component) {
        components.add(component);
    }

    public static void revealAll() {
        components.forEach(Component::revealCombined);
        statusEffectComponents.values().forEach(Component::revealCombined);
    }

    public static void revealAll(float visibleTime) {
        components.forEach(component -> component.revealCombined(visibleTime));
        statusEffectComponents.values().forEach(component -> component.revealCombined(visibleTime));
    }

    public static void forceHideAll() {
        components.forEach(Component::forceHide);
    }

    public static void updateAll() {
        components.forEach(component -> {
            if (component.state != null) {
                component.state.updateNextTick();
            }
        });
    }

    public static void hideAll() {
        components.forEach(Component::hide);
        statusEffectComponents.values().forEach(Component::hide);
    }

    public static void tickAll() {
        components.forEach(Component::tick);
        statusEffectComponents.values().forEach(Component::tick);
        Components.ChatIndicator.tick();
    }

    private Component(ResourceLocation identifier, Supplier<Boolean> isTargeted, ConfigHandler.IComponent config, List<Component> stackComponents, boolean inMainHud, boolean register, Function<LocalPlayer, ComponentState> stateProvider) {
        this.identifier = identifier;
        this.isTargeted = isTargeted;
        this.config = config;
        this.stackComponents = new ArrayList<Component>(stackComponents);
        this.inMainHud = inMainHud;
        if (inMainHud) {
            mainHudComponents.add(this);
        }
        this.stateProvider = stateProvider;
        if (register) {
            Component.registerComponent(this);
        }
    }

    public static Builder builder(String name) {
        return Component.builder(VersionUtils.getIdentifier((String)"autohud", (String)name));
    }

    public static Builder builder(String path, String name) {
        return Component.builder(VersionUtils.getIdentifier((String)path, (String)name));
    }

    public static Builder builder(ResourceLocation identifier) {
        return new Builder(identifier);
    }

    public static void registerStatusEffect(MobEffect effect) {
        if (!statusEffectComponents.containsKey(effect)) {
            Component c = Component.builder(effect.m_19481_()).config(AutoHud.config.statusEffects()).isTargeted(() -> AutoHud.targetStatusEffects).register(false).build();
            c.offset = 1.0;
            c.alpha = 0.0;
            statusEffectComponents.put(effect, c);
            ComponentRenderer.registerStatusEffectComponent(c);
        }
    }

    public static Component get(MobEffect effect) {
        Component.registerStatusEffect(effect);
        return statusEffectComponents.get(effect);
    }

    public static Collection<Component> getComponents() {
        return components;
    }

    public static Collection<Component> getStatusEffectComponents() {
        return statusEffectComponents.values();
    }

    public static Component findBySprite(TextureAtlasSprite sprite) {
        MobEffectTextureManager statusEffectSpriteManager = Minecraft.m_91087_().m_91306_();
        for (MobEffect effect : statusEffectComponents.keySet()) {
            if (statusEffectSpriteManager.m_118732_(effect) != sprite) continue;
            return statusEffectComponents.get(effect);
        }
        return null;
    }

    public double getOffsetX(float tickDelta) {
        if (!AutoHud.config.animationMove() && AutoHud.config.animationFade()) {
            return 0.0;
        }
        return switch (this.config.direction()) {
            default -> throw new IncompatibleClassChangeError();
            case ScrollDirection.Up, ScrollDirection.Down -> 0.0;
            case ScrollDirection.Left -> -(this.offset + (double)tickDelta * this.offsetDelta) * (double)this.config.distance();
            case ScrollDirection.Right -> (this.offset + (double)tickDelta * this.offsetDelta) * (double)this.config.distance();
        };
    }

    public double getOffsetY(float tickDelta) {
        if (!AutoHud.config.animationMove() && AutoHud.config.animationFade()) {
            return 0.0;
        }
        return switch (this.config.direction()) {
            default -> throw new IncompatibleClassChangeError();
            case ScrollDirection.Up -> -(this.offset + (double)tickDelta * this.offsetDelta) * (double)this.config.distance();
            case ScrollDirection.Down -> (this.offset + (double)tickDelta * this.offsetDelta) * (double)this.config.distance();
            case ScrollDirection.Left, ScrollDirection.Right -> 0.0;
        };
    }

    public float getAlpha(float tickDelta) {
        if (!AutoHud.config.animationFade()) {
            return 1.0f;
        }
        return (float)((1.0 - this.config.maximumFade()) * (this.alpha + (double)tickDelta * this.alphaDelta) + this.config.maximumFade());
    }

    public boolean isHidden() {
        return !this.fullyRevealed();
    }

    public boolean isActive() {
        return this.config.active() && this.isTargeted.get() != false;
    }

    public void revealFromHidden() {
        this.offset = 1.0;
        this.alpha = 0.0;
        this.offsetDelta = 0.0;
        this.alphaDelta = 0.0;
        this.reveal();
    }

    public void reveal() {
        this.visibleTime = AutoHud.config.timeRevealed();
    }

    public void revealCombined() {
        this.revealCombined(AutoHud.config.timeRevealed());
    }

    public void revealCombined(float visibleTime) {
        this.visibleTime = visibleTime;
        if (this.isActive()) {
            switch (AutoHud.config.revealType()) {
                case Combined: {
                    components.forEach(c -> {
                        c.visibleTime = Math.max(c.visibleTime, visibleTime);
                    });
                    break;
                }
                case HideCombined: {
                    components.forEach(c -> c.keepRevealed(visibleTime));
                    break;
                }
                case Stacked: {
                    this.keepRevealedStacked(visibleTime);
                    break;
                }
                case Grouped: {
                    this.revealGrouped(visibleTime);
                    break;
                }
            }
        }
    }

    private void revealGrouped(float visibleTime) {
        if (this.inMainHud) {
            mainHudComponents.forEach(c -> {
                c.visibleTime = Math.max(c.visibleTime, visibleTime);
            });
        }
    }

    private void keepRevealedStacked(float visibleTime) {
        this.keepRevealed(visibleTime);
        this.stackComponents.forEach(c -> c.keepRevealedStacked(visibleTime));
    }

    public void addStackComponent(Component component) {
        this.stackComponents.add(component);
    }

    public void revealNow() {
        this.visibleTime = AutoHud.config.timeRevealed();
        this.offset = 0.0;
        this.offsetDelta = 0.0;
        this.alpha = 1.0;
        this.alphaDelta = 0.0;
    }

    public void hideNow() {
        this.visibleTime = 0.0f;
        this.offset = 1.0;
        this.alpha = 0.0;
        this.offsetDelta = 0.0;
        this.alphaDelta = 0.0;
    }

    public void hide() {
        if (!this.isActive()) {
            return;
        }
        this.visibleTime = 0.0f;
        if (this.state != null) {
            this.state.updateNextTick();
        }
    }

    public void forceHide() {
        if (!this.isActive()) {
            return;
        }
        this.visibleTime = 0.0f;
    }

    public boolean fullyRevealed() {
        return this.offset == 0.0 && this.alpha == 1.0;
    }

    public boolean fullyHidden() {
        return this.offset == 1.0 && this.alpha == 0.0;
    }

    public boolean shouldRender() {
        if (!this.config.active()) {
            return true;
        }
        if (AutoHud.config.animationFade()) {
            return !this.fullyHidden() || this.config.maximumFade() > 0.0;
        }
        return !this.fullyHidden() || this.config.renderWhenHidden();
    }

    private void keepRevealed(float time) {
        if (this.isActive() && this.visibleTime > 0.0f && this.visibleTime < time) {
            this.visibleTime = time;
        }
    }

    private void synchronize(float newVisibleTime, double newOffset, double newAlpha, double newOffsetDelta, double newAlphaDelta, Component ... components) {
        for (Component component : components) {
            newVisibleTime = Math.max(newVisibleTime, component.visibleTime);
            if (newOffset >= component.offset) {
                newOffsetDelta = this.offset + this.offsetDelta < component.offset + component.offsetDelta ? component.offset + component.offsetDelta - this.offset : component.offsetDelta;
                newOffset = component.offset;
            }
            if (!(newAlpha <= component.alpha)) continue;
            newAlphaDelta = this.alpha + this.alphaDelta > component.alpha + component.alphaDelta ? this.alpha - (component.alpha + component.alphaDelta) : component.alphaDelta;
            newAlpha = component.alpha;
        }
        this.visibleTime = newVisibleTime;
        this.offset = newOffset;
        this.alpha = newAlpha;
        this.offsetDelta = newOffsetDelta;
        this.alphaDelta = newAlphaDelta;
    }

    public void synchronizeFromHidden(Component ... components) {
        this.synchronize(0.0f, 1.0, 0.0, 0.0, 0.0, components);
    }

    public void synchronizeFrom(Component ... components) {
        this.synchronize(this.visibleTime, this.offset, this.alpha, this.offsetDelta, this.alphaDelta, components);
    }

    private void moveIn() {
        this.offset = Math.max(0.0, this.offset + this.offsetDelta);
        this.alpha = Math.min(1.0, this.alpha + this.alphaDelta);
        double offsetSpeed = Math.sqrt(0.01 + this.offset) * 0.1 * AutoHud.config.animationSpeedMoveIn() * this.config.speedMultiplier();
        double alphaSpeed = 0.05 * AutoHud.config.animationSpeedFadeIn() * this.config.speedMultiplier();
        this.offsetDelta = this.offset - offsetSpeed <= 0.0 ? -this.offset : -offsetSpeed;
        this.alphaDelta = this.alpha + alphaSpeed >= 1.0 ? 1.0 - this.alpha : alphaSpeed;
    }

    private void moveOut() {
        this.offset = Math.min(1.0, this.offset + this.offsetDelta);
        this.alpha = Math.max(0.0, this.alpha + this.alphaDelta);
        double offsetSpeed = Math.sqrt(0.01 + this.offset) * 0.1 * AutoHud.config.animationSpeedMoveOut() * this.config.speedMultiplier();
        double alphaSpeed = 0.05 * AutoHud.config.animationSpeedFadeOut() * this.config.speedMultiplier();
        this.offsetDelta = this.offset + offsetSpeed >= 1.0 ? 1.0 - this.offset : offsetSpeed;
        this.alphaDelta = this.alpha - alphaSpeed <= 0.0 ? -this.alpha : -alphaSpeed;
    }

    public void revealIf(boolean trigger) {
        if (!this.isActive() || this.config.onChange() && trigger) {
            this.revealCombined();
        }
    }

    public void initState(LocalPlayer player) {
        if (this.stateProvider != null) {
            this.state = this.stateProvider.apply(player);
        }
    }

    public void updateState() {
        if (this.state != null) {
            this.state.update();
        }
    }

    public void updateStateNextTick() {
        if (this.state != null) {
            this.state.updateNextTick();
        }
    }

    public boolean isMoreVisibleThan(Component other) {
        return this.offset < other.offset;
    }

    public void tick() {
        if (this.state != null) {
            this.state.tick();
        }
        if (this.visibleTime == 0.0f) {
            if (!(this.fullyHidden() || this.state != null && this.state.scheduledUpdate())) {
                if (AutoHud.config.animationNone()) {
                    this.hideNow();
                } else {
                    this.moveOut();
                }
            }
            if (this.offset == 1.0) {
                this.offsetDelta = 0.0;
            }
            if (this.alpha == 0.0) {
                this.alphaDelta = 0.0;
            }
        } else if (!this.fullyRevealed()) {
            if (AutoHud.config.animationNone()) {
                this.revealNow();
            } else {
                this.moveIn();
            }
        } else {
            if (this.offset == 0.0) {
                this.offsetDelta = 0.0;
            }
            if (this.alpha == 1.0) {
                this.alphaDelta = 0.0;
            }
        }
        if (this.isActive() && Hud.actDynamic() && this.visibleTime > 0.0f) {
            this.visibleTime = Math.max(0.0f, this.visibleTime - 1.0f);
            if (this.visibleTime == 0.0f && this.state != null) {
                this.state.updateNextTick();
            }
        }
    }

    public static class Builder {
        ResourceLocation identifier;
        Supplier<Boolean> isTargeted = () -> true;
        ConfigHandler.IComponent config = ConfigHandler.None;
        List<Component> stackComponents = List.of();
        boolean inMainHud = false;
        boolean register = true;
        private Function<LocalPlayer, ComponentState> stateProvider;

        private Builder(ResourceLocation identifier) {
            this.identifier = identifier;
        }

        public Builder isTargeted(Supplier<Boolean> isTargeted) {
            this.isTargeted = isTargeted;
            return this;
        }

        public Builder config(ConfigHandler.IComponent config) {
            this.config = config;
            return this;
        }

        public Builder stackComponents(Component ... stackComponents) {
            return this.stackComponents(Arrays.stream(stackComponents).toList());
        }

        public Builder stackComponents(List<Component> stackComponents) {
            this.stackComponents = stackComponents;
            return this;
        }

        public Builder inMainHud() {
            return this.inMainHud(true);
        }

        public Builder inMainHud(boolean inMainHud) {
            this.inMainHud = inMainHud;
            return this;
        }

        public Builder state(Function<LocalPlayer, ComponentState> stateProvider) {
            this.stateProvider = stateProvider;
            return this;
        }

        public Builder register(boolean register) {
            this.register = register;
            return this;
        }

        public Component build() {
            return new Component(this.identifier, this.isTargeted, this.config, this.stackComponents, this.inMainHud, this.register, this.stateProvider);
        }
    }
}

