/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.component;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mod.crend.autohud.AutoHud;
import mod.crend.autohud.component.Component;
import mod.crend.autohud.component.Components;
import mod.crend.libbamboo.type.ItemOrTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.phys.HitResult;

public class State {
    private Map<MobEffect, MobEffectInstance> previousStatusEffects;

    public State(LocalPlayer player) {
        this.initStates(player);
        this.previousStatusEffects = new HashMap<MobEffect, MobEffectInstance>();
    }

    public void initStates(LocalPlayer player) {
        Component.getComponents().forEach(component -> component.initState(player));
        Components.ChatIndicator.hideNow();
        AutoHud.apis.forEach(api -> api.initState(player));
    }

    static boolean shouldShowCrosshair() {
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91077_ != null && client.f_91077_.m_6662_() != HitResult.Type.MISS) {
            return true;
        }
        if (client.f_91074_ != null) {
            for (ItemOrTag itemOrTag : AutoHud.config.crosshairAlwaysVisible()) {
                if (!itemOrTag.matches(client.f_91074_.m_21205_().m_41720_()) && !itemOrTag.matches(client.f_91074_.m_21206_().m_41720_())) continue;
                return true;
            }
        }
        return false;
    }

    static boolean isFood(ItemStack itemStack) {
        return itemStack.m_41614_();
    }

    private static boolean isHealEffect(MobEffectInstance effect) {
        return effect.m_19544_() == MobEffects.f_19605_ || effect.m_19544_() == MobEffects.f_19601_ || effect.m_19544_() == MobEffects.f_19616_ || effect.m_19544_() == MobEffects.f_19617_;
    }

    static boolean canHeal() {
        block4: {
            ItemStack itemStack;
            block3: {
                itemStack = Minecraft.m_91087_().f_91074_.m_21205_();
                if (!State.isFood(itemStack)) break block3;
                if (itemStack.m_41720_().m_41473_() == null) {
                    return false;
                }
                List statusEffects = itemStack.m_41720_().m_41473_().m_38749_();
                for (Pair effect : statusEffects) {
                    if (!State.isHealEffect((MobEffectInstance)effect.getFirst())) continue;
                    return true;
                }
                break block4;
            }
            if (!(itemStack.m_41720_() instanceof PotionItem)) break block4;
            Potion potion = PotionUtils.m_43579_((ItemStack)itemStack);
            for (MobEffectInstance effect : potion.m_43488_()) {
                if (!State.isHealEffect(effect)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean revealHotbarOnDurability(ItemStack itemStack) {
        if (itemStack.m_41763_() && (double)itemStack.m_41773_() >= (double)(100 - AutoHud.config.getHotbarDurabilityPercentage()) / 100.0 * (double)itemStack.m_41776_() && itemStack.m_41776_() - itemStack.m_41773_() < AutoHud.config.getHotbarDurabilityTotal()) {
            Components.Hotbar.revealCombined();
            Components.Tooltip.revealCombined();
            return true;
        }
        return false;
    }

    public void tick(LocalPlayer player) {
        if (player == null) {
            return;
        }
        Component.tickAll();
        if (AutoHud.config.isHotbarOnLowDurability() && !this.revealHotbarOnDurability(player.m_21205_())) {
            this.revealHotbarOnDurability(player.m_21206_());
        }
        if (AutoHud.config.revealExperienceTextWithHotbar()) {
            Components.ExperienceLevel.synchronizeFrom(Components.ExperienceBar, Components.Hotbar);
        }
        if (AutoHud.config.statusEffects().active()) {
            if (AutoHud.config.statusEffects().onChange()) {
                HashMap<MobEffect, MobEffectInstance> newStatusEffects = new HashMap<MobEffect, MobEffectInstance>();
                Map effects = player.m_21221_();
                for (MobEffect effect : effects.keySet()) {
                    MobEffectInstance effectInstance = (MobEffectInstance)effects.get(effect);
                    if (!effectInstance.m_19575_() && !AutoHud.config.showHiddenStatusEffects()) continue;
                    if (effectInstance.m_19557_() < 5) {
                        Component.get(effect).hide();
                    } else if (!this.previousStatusEffects.containsKey(effect)) {
                        Component.get(effect).revealFromHidden();
                    } else if (!AutoHud.config.hidePersistentStatusEffects() || !this.previousStatusEffects.get(effect).equals((Object)effectInstance)) {
                        Component.get(effect).reveal();
                    }
                    newStatusEffects.put(effect, new MobEffectInstance(effectInstance));
                }
                this.previousStatusEffects = newStatusEffects;
            }
        } else {
            Component.getStatusEffectComponents().forEach(Component::reveal);
            if (AutoHud.config.hidePersistentStatusEffects()) {
                HashMap<MobEffect, MobEffectInstance> newStatusEffects = new HashMap<MobEffect, MobEffectInstance>();
                Map effects = player.m_21221_();
                for (MobEffect effect : effects.keySet()) {
                    MobEffectInstance effectInstance = (MobEffectInstance)effects.get(effect);
                    if (!effectInstance.m_19575_()) continue;
                    if (this.previousStatusEffects.containsKey(effect) && this.previousStatusEffects.get(effect).equals((Object)effectInstance)) {
                        Component.get(effect).hideNow();
                    }
                    newStatusEffects.put(effect, new MobEffectInstance(effectInstance));
                }
                this.previousStatusEffects = newStatusEffects;
            }
        }
        AutoHud.apis.forEach(api -> api.tickState(player));
    }
}

