/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.component.state;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectIntMutablePair;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import mod.crend.autohud.component.Component;
import mod.crend.autohud.component.state.ValueComponentState;
import mod.crend.autohud.mixin.TeamMixinAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.Scoreboard;

public class ScoreboardComponentState
extends ValueComponentState<Objective> {
    net.minecraft.network.chat.Component cachedDisplayName;
    Map<String, Pair<PlayerTeam, Integer>> cachedTeams = new HashMap<String, Pair<PlayerTeam, Integer>>();
    Map<String, Pair<String, Integer>> cachedPlayerScores = new HashMap<String, Pair<String, Integer>>();

    public ScoreboardComponentState(Component component) {
        super(component, ScoreboardComponentState::createObjective, true);
        this.collectPlayerScores((Objective)this.oldValue);
    }

    private static Objective createObjective() {
        if (Minecraft.m_91087_().f_91073_ == null || Minecraft.m_91087_().f_91074_ == null) {
            return null;
        }
        Scoreboard scoreboard = Minecraft.m_91087_().f_91073_.m_6188_();
        PlayerTeam playerTeam = scoreboard.m_83500_(Minecraft.m_91087_().f_91074_.m_6302_());
        if (playerTeam != null && playerTeam.m_7414_().m_126664_()) {
            return scoreboard.m_83416_(3 + playerTeam.m_7414_().m_126656_());
        }
        return scoreboard.m_83416_(1);
    }

    @Override
    protected void onUpdateReveal(Objective newObjective) {
        if (!Objects.equals(newObjective, this.oldValue)) {
            this.collectPlayerScores(newObjective);
        }
    }

    private void collectPlayerScores(Objective objective) {
        if (objective == null) {
            return;
        }
        this.cachedTeams.clear();
        this.cachedPlayerScores.clear();
        this.cachedDisplayName = objective.m_83322_();
        objective.m_83313_().m_83498_(objective).forEach(this::addPlayerScoreAndTeam);
    }

    private void addPlayerScoreAndTeam(Score playerScore) {
        String playerName = playerScore.m_83405_();
        if (playerScore.m_83404_() == null) {
            return;
        }
        PlayerTeam playerTeam = playerScore.m_83404_().m_83313_().m_83500_(playerScore.m_83405_());
        int score = playerScore.m_83400_();
        String teamName = playerTeam == null ? null : playerTeam.m_5758_();
        this.cachedPlayerScores.put(playerName, (Pair<String, Integer>)new ObjectIntMutablePair((Object)teamName, score));
        if (teamName == null) {
            return;
        }
        if (this.cachedTeams.containsKey(teamName)) {
            Pair<PlayerTeam, Integer> teamEntry = this.cachedTeams.get(teamName);
            teamEntry.right((Object)((Integer)teamEntry.right() + 1));
        } else {
            this.cachedTeams.put(teamName, (Pair<PlayerTeam, Integer>)new ObjectIntMutablePair((Object)ScoreboardComponentState.copyTeam(playerTeam), 1));
        }
    }

    public void updateObjectiveDisplayName(Objective objective) {
        net.minecraft.network.chat.Component newDisplayName;
        if (Objects.equals(this.oldValue, objective) && !ScoreboardComponentState.isTextEqual(newDisplayName = objective.m_83322_(), this.cachedDisplayName)) {
            this.cachedDisplayName = newDisplayName;
            this.component.revealCombined();
        }
    }

    public void onPlayerScoreUpdate(Score score) {
        Objective objective = score.m_83404_();
        String playerName = score.m_83405_();
        if (Objects.equals(this.oldValue, objective)) {
            if (this.cachedPlayerScores.containsKey(playerName)) {
                Pair<String, Integer> cachedTeamAndScore = this.cachedPlayerScores.get(playerName);
                if (cachedTeamAndScore.right() == null || ((Integer)cachedTeamAndScore.right()).intValue() != score.m_83400_()) {
                    this.component.revealCombined();
                    cachedTeamAndScore.right((Object)score.m_83400_());
                }
            } else {
                this.addPlayerScoreAndTeam(score);
                this.component.revealCombined();
            }
        }
    }

    public void onPlayerScoreRemove(String playerName) {
        if (this.cachedPlayerScores.containsKey(playerName)) {
            Pair<String, Integer> cachedTeamAndScore = this.cachedPlayerScores.get(playerName);
            if (cachedTeamAndScore.left() != null && this.cachedTeams.containsKey(cachedTeamAndScore.left())) {
                this.onTeamRemovedFromPlayer((PlayerTeam)this.cachedTeams.get(cachedTeamAndScore.left()).left());
            }
            this.cachedPlayerScores.remove(playerName);
        }
    }

    public void onPlayerScoreRemove(String playerName, Objective objective) {
        if (Objects.equals(this.oldValue, objective)) {
            this.onPlayerScoreRemove(playerName);
        }
    }

    public void onTeamRemoved(PlayerTeam team) {
        if (this.cachedPlayerScores.isEmpty()) {
            return;
        }
        boolean revealComponent = false;
        for (Map.Entry<String, Pair<String, Integer>> stringPairEntry : this.cachedPlayerScores.entrySet()) {
            Pair<String, Integer> cachedPair = stringPairEntry.getValue();
            if (!Objects.equals(cachedPair.left(), team.m_5758_())) continue;
            cachedPair.left(null);
            revealComponent = true;
        }
        this.cachedTeams.remove(team.m_5758_());
        if (revealComponent) {
            this.component.revealCombined();
        }
    }

    public void onTeamUpdated(PlayerTeam team) {
        if (this.cachedTeams.isEmpty() || !this.cachedTeams.containsKey(team.m_5758_())) {
            return;
        }
        Pair<PlayerTeam, Integer> cachedTeam = this.cachedTeams.get(team.m_5758_());
        if (!ScoreboardComponentState.isTeamEqual(team, (PlayerTeam)cachedTeam.left())) {
            this.component.revealCombined();
            cachedTeam.left((Object)ScoreboardComponentState.copyTeam(team));
        }
    }

    public void onPlayerAddedToTeam(String playerName, PlayerTeam team) {
        if (this.cachedPlayerScores.isEmpty()) {
            return;
        }
        Pair<String, Integer> cachedTeamAndScore = this.cachedPlayerScores.get(playerName);
        if (cachedTeamAndScore == null) {
            return;
        }
        if (!Objects.equals(cachedTeamAndScore.left(), team.m_5758_())) {
            boolean cachedTeamHasDifferences;
            boolean cachedPlayerTeamIsEmpty = cachedTeamAndScore.left() == null;
            Pair<PlayerTeam, Integer> cachedTeam = cachedPlayerTeamIsEmpty ? null : this.cachedTeams.get(cachedTeamAndScore.left());
            boolean bl = cachedTeamHasDifferences = !cachedPlayerTeamIsEmpty && cachedTeam != null && !ScoreboardComponentState.isTeamEqual(team, (PlayerTeam)cachedTeam.left());
            if (cachedPlayerTeamIsEmpty || cachedTeamHasDifferences) {
                if (cachedTeamHasDifferences) {
                    this.onTeamRemovedFromPlayer((PlayerTeam)cachedTeam.left());
                }
                this.component.revealCombined();
                cachedTeamAndScore.left((Object)team.m_5758_());
                this.onTeamAddedToPlayer(team);
            }
        }
    }

    public void onPlayerRemovedFromTeam(String playerName, PlayerTeam team) {
        if (this.cachedPlayerScores.isEmpty()) {
            return;
        }
        Pair<String, Integer> cachedTeamAndScore = this.cachedPlayerScores.get(playerName);
        if (cachedTeamAndScore != null && Objects.equals(cachedTeamAndScore.left(), team.m_5758_())) {
            this.component.revealCombined();
            cachedTeamAndScore.left(null);
            this.onTeamRemovedFromPlayer(team);
        }
    }

    private void onTeamAddedToPlayer(PlayerTeam teamAddedTo) {
        Pair<PlayerTeam, Integer> cachedTeam = this.cachedTeams.get(teamAddedTo.m_5758_());
        if (cachedTeam == null) {
            this.cachedTeams.put(teamAddedTo.m_5758_(), (Pair<PlayerTeam, Integer>)new ObjectIntMutablePair((Object)ScoreboardComponentState.copyTeam(teamAddedTo), 1));
        } else {
            cachedTeam.right((Object)((Integer)cachedTeam.right() + 1));
        }
    }

    private void onTeamRemovedFromPlayer(PlayerTeam teamRemovedFrom) {
        Pair<PlayerTeam, Integer> cachedTeam = this.cachedTeams.get(teamRemovedFrom.m_5758_());
        if (cachedTeam == null) {
            return;
        }
        if ((Integer)cachedTeam.right() - 1 < 1) {
            this.cachedTeams.remove(teamRemovedFrom.m_5758_());
        } else {
            cachedTeam.right((Object)((Integer)cachedTeam.right() - 1));
        }
    }

    private static boolean isTeamEqual(PlayerTeam team, PlayerTeam cachedTeam) {
        if (team == cachedTeam) {
            return true;
        }
        if (team == null || cachedTeam == null) {
            return false;
        }
        return team.m_5758_().equals(cachedTeam.m_5758_()) && team.m_7414_() == cachedTeam.m_7414_() && ScoreboardComponentState.isTextEqual(team.m_83364_(), cachedTeam.m_83364_()) && ScoreboardComponentState.isTextEqual(team.m_83370_(), cachedTeam.m_83370_()) && ScoreboardComponentState.isTextEqual(team.m_83371_(), cachedTeam.m_83371_());
    }

    private static boolean isTextEqual(net.minecraft.network.chat.Component left, net.minecraft.network.chat.Component right) {
        boolean rightIsEmpty;
        boolean leftIsEmpty = left == null;
        boolean bl = rightIsEmpty = right == null;
        if (leftIsEmpty && rightIsEmpty) {
            return true;
        }
        if (leftIsEmpty != rightIsEmpty) {
            return false;
        }
        return left.getString().equals(right.getString());
    }

    private static PlayerTeam copyTeam(PlayerTeam team) {
        PlayerTeam copiedTeam = new PlayerTeam(null, team.m_5758_());
        ((TeamMixinAccessor)copiedTeam).autohud$setDisplayName(team.m_83364_());
        ((TeamMixinAccessor)copiedTeam).autohud$setColor(team.m_7414_());
        ScoreboardComponentState.teamSetPrefix(copiedTeam, team.m_83370_());
        ScoreboardComponentState.teamSetSuffix(copiedTeam, team.m_83371_());
        return copiedTeam;
    }

    private static void teamSetPrefix(PlayerTeam copiedTeam, net.minecraft.network.chat.Component prefix) {
        ((TeamMixinAccessor)copiedTeam).autohud$setPrefix((net.minecraft.network.chat.Component)(prefix == null ? net.minecraft.network.chat.Component.m_237119_() : prefix.m_6881_()));
    }

    private static void teamSetSuffix(PlayerTeam copiedTeam, net.minecraft.network.chat.Component suffix) {
        ((TeamMixinAccessor)copiedTeam).autohud$setSuffix((net.minecraft.network.chat.Component)(suffix == null ? net.minecraft.network.chat.Component.m_237119_() : suffix.m_6881_()));
    }
}

