/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.config;

import com.google.gson.JsonObject;
import java.util.List;
import mod.crend.autohud.config.Config;
import mod.crend.autohud.config.EventPolicy;
import mod.crend.autohud.config.RevealPolicy;
import mod.crend.autohud.config.RevealType;
import mod.crend.autohud.config.ScrollDirection;
import mod.crend.libbamboo.opt.ConfigStore;
import mod.crend.libbamboo.opt.ConfigUpdater;
import mod.crend.libbamboo.type.ItemOrTag;

public class ConfigHandler {
    public static final ConfigStore<Config> CONFIG_STORE = new ConfigStore(Config.class, (ConfigUpdater)new AutoHudConfigUpdater());
    public static final IComponent None = new SimpleComponent(new Config.SimpleComponent(), new Config.AdvancedComponent(), new Config.DefaultValues());
    public static final IComponent DummyPolicyComponent = new PolicyComponent(new Config.PolicyComponent(), new Config.AdvancedComponent(), new Config.DefaultValues());
    public static final IComponent DummyBooleanComponent = new BooleanComponent(new Config.BooleanComponent(), new Config.AdvancedComponent(), new Config.DefaultValues());
    PolicyComponent health;
    PolicyComponent armor;
    PolicyComponent hunger;
    PolicyComponent air;
    BooleanComponent experience;
    BooleanComponent experienceBar;
    BooleanComponent mountJumpBar;
    PolicyComponent mountHealth;
    BooleanComponent hotbar;
    IComponent tooltip;
    BooleanComponent statusEffects;
    BooleanComponent scoreboard;
    BooleanFadeOnlyComponent crosshair;
    SimpleComponent chat;
    IComponent chatIndicator;
    SimpleComponent actionBar;
    SimpleComponent bossBar;

    public ConfigHandler() {
        this.init();
    }

    public boolean dynamicOnLoad() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).dynamicOnLoad;
    }

    public int timeRevealed() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).ticksRevealed;
    }

    public boolean animationMove() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).animationMove;
    }

    public boolean animationFade() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).animationFade;
    }

    public boolean animationNone() {
        return !((Config)ConfigHandler.CONFIG_STORE.config()).animationMove && !((Config)ConfigHandler.CONFIG_STORE.config()).animationFade;
    }

    public double animationSpeed() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).animationSpeed;
    }

    public double animationSpeedMoveIn() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).animationSpeeds.moveIn == 0.0 ? ((Config)ConfigHandler.CONFIG_STORE.config()).animationSpeed : ((Config)ConfigHandler.CONFIG_STORE.config()).animationSpeeds.moveIn;
    }

    public double animationSpeedMoveOut() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).animationSpeeds.moveOut == 0.0 ? ((Config)ConfigHandler.CONFIG_STORE.config()).animationSpeed : ((Config)ConfigHandler.CONFIG_STORE.config()).animationSpeeds.moveOut;
    }

    public double animationSpeedFadeIn() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).animationSpeeds.fadeIn == 0.0 ? ((Config)ConfigHandler.CONFIG_STORE.config()).animationSpeed : ((Config)ConfigHandler.CONFIG_STORE.config()).animationSpeeds.fadeIn;
    }

    public double animationSpeedFadeOut() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).animationSpeeds.fadeOut == 0.0 ? ((Config)ConfigHandler.CONFIG_STORE.config()).animationSpeed : ((Config)ConfigHandler.CONFIG_STORE.config()).animationSpeeds.fadeOut;
    }

    public RevealType revealType() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).revealType;
    }

    public EventPolicy onScreenOpen() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).events.onScreenOpen;
    }

    public EventPolicy onMoving() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).events.onMoving;
    }

    public EventPolicy onStandingStill() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).events.onStandingStill;
    }

    public EventPolicy onPauseScreen() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).events.onPauseScreen;
    }

    public EventPolicy onSneaking() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).events.onSneaking;
    }

    public EventPolicy onFlying() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).events.onFlying;
    }

    public boolean onUsingItem() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).events.onUsingItem;
    }

    public boolean onMining() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).events.onMining;
    }

    public boolean onSwinging() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).events.onSwinging;
    }

    public boolean onAttacking() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).events.onAttacking;
    }

    public boolean statusEffectTimer() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).statusEffectTimer;
    }

    public PolicyComponent health() {
        return this.health;
    }

    public PolicyComponent armor() {
        return this.armor;
    }

    public PolicyComponent hunger() {
        return this.hunger;
    }

    public boolean revealBarsWhenHoldingConsumableItem() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).revealBarsWhenHoldingConsumableItem;
    }

    public PolicyComponent air() {
        return this.air;
    }

    public BooleanComponent experience() {
        return this.experience;
    }

    public BooleanComponent experienceBar() {
        return this.experienceBar;
    }

    public BooleanComponent mountJumpBar() {
        return this.mountJumpBar;
    }

    public PolicyComponent mountHealth() {
        return this.mountHealth;
    }

    public BooleanComponent hotbar() {
        return this.hotbar;
    }

    public boolean isHotbarOnDamageChange() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).hotbar.onDamageChange;
    }

    public boolean isHotbarOnStackSizeChange() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).hotbar.onStackSizeChange;
    }

    public boolean isHotbarOnSlotChange() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).hotbar.onSlotChange;
    }

    public boolean isHotbarOnLowDurability() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).hotbar.onLowDurability;
    }

    public int getHotbarDurabilityPercentage() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).hotbar.durabilityPercentage;
    }

    public int getHotbarDurabilityTotal() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).hotbar.durabilityTotal;
    }

    public float getHotbarItemsMaximumFade() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).hotbar.maximumFadeHotbarItems;
    }

    public boolean revealExperienceTextWithHotbar() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).hotbar.revealExperienceTextWithHotbar;
    }

    public boolean revealExperienceTextOnTargetingEnchantingBlock() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).revealExperienceTextOnTargetingEnchantingBlock;
    }

    public IComponent tooltip() {
        return this.tooltip;
    }

    public BooleanComponent statusEffects() {
        return this.statusEffects;
    }

    public boolean hidePersistentStatusEffects() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).hidePersistentStatusEffects;
    }

    public boolean showHiddenStatusEffects() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).showHiddenStatusEffects;
    }

    public BooleanComponent scoreboard() {
        return this.scoreboard;
    }

    public BooleanFadeOnlyComponent crosshair() {
        return this.crosshair;
    }

    public List<ItemOrTag> crosshairAlwaysVisible() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).crosshairAlwaysVisible;
    }

    public boolean shouldRevealScoreboardOnTitleChange() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).scoreboard.scoreboard.onChange;
    }

    public boolean shouldRevealScoreboardOnScoreChange() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).scoreboard.onScoreChange;
    }

    public boolean shouldRevealScoreboardOnTeamChange() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).scoreboard.onTeamChange;
    }

    public SimpleComponent chat() {
        return this.chat;
    }

    public IComponent chatIndicator() {
        return this.chatIndicator;
    }

    public SimpleComponent actionBar() {
        return this.actionBar;
    }

    public SimpleComponent bossBar() {
        return this.bossBar;
    }

    private void init() {
        this.health = new PolicyComponent(((Config)ConfigHandler.CONFIG_STORE.config()).health, ((Config)ConfigHandler.CONFIG_STORE.config()).advanced.health, ((Config)ConfigHandler.CONFIG_STORE.config()).defaultValues);
        this.armor = new PolicyComponent(((Config)ConfigHandler.CONFIG_STORE.config()).armor, ((Config)ConfigHandler.CONFIG_STORE.config()).advanced.armor, ((Config)ConfigHandler.CONFIG_STORE.config()).defaultValues);
        this.hunger = new PolicyComponent(((Config)ConfigHandler.CONFIG_STORE.config()).hunger, ((Config)ConfigHandler.CONFIG_STORE.config()).advanced.hunger, ((Config)ConfigHandler.CONFIG_STORE.config()).defaultValues);
        this.air = new PolicyComponent(((Config)ConfigHandler.CONFIG_STORE.config()).air, ((Config)ConfigHandler.CONFIG_STORE.config()).advanced.air, ((Config)ConfigHandler.CONFIG_STORE.config()).defaultValues);
        this.experience = new BooleanComponent(((Config)ConfigHandler.CONFIG_STORE.config()).experience, ((Config)ConfigHandler.CONFIG_STORE.config()).advanced.experience, ((Config)ConfigHandler.CONFIG_STORE.config()).defaultValues);
        this.experienceBar = new BooleanComponent(((Config)ConfigHandler.CONFIG_STORE.config()).experienceBar, ((Config)ConfigHandler.CONFIG_STORE.config()).advanced.experience, ((Config)ConfigHandler.CONFIG_STORE.config()).defaultValues);
        this.mountJumpBar = new BooleanComponent(((Config)ConfigHandler.CONFIG_STORE.config()).mountJumpBar, ((Config)ConfigHandler.CONFIG_STORE.config()).advanced.mountJumpBar, ((Config)ConfigHandler.CONFIG_STORE.config()).defaultValues);
        this.mountHealth = new PolicyComponent(((Config)ConfigHandler.CONFIG_STORE.config()).mountHealth, ((Config)ConfigHandler.CONFIG_STORE.config()).advanced.mountHealth, ((Config)ConfigHandler.CONFIG_STORE.config()).defaultValues);
        this.hotbar = new BooleanComponent(((Config)ConfigHandler.CONFIG_STORE.config()).hotbar.hotbar, ((Config)ConfigHandler.CONFIG_STORE.config()).advanced.hotbar, ((Config)ConfigHandler.CONFIG_STORE.config()).defaultValues);
        this.tooltip = new BooleanComponent(((Config)ConfigHandler.CONFIG_STORE.config()).hotbar.hotbar, ((Config)ConfigHandler.CONFIG_STORE.config()).advanced.hotbar, ((Config)ConfigHandler.CONFIG_STORE.config()).defaultValues){

            @Override
            public boolean active() {
                return ((Config)ConfigHandler.CONFIG_STORE.config()).hotbar.hideTooltip || super.active();
            }

            @Override
            public boolean onChange() {
                return !((Config)ConfigHandler.CONFIG_STORE.config()).hotbar.hideTooltip && super.onChange();
            }
        };
        this.statusEffects = new BooleanComponent(((Config)ConfigHandler.CONFIG_STORE.config()).statusEffects, ((Config)ConfigHandler.CONFIG_STORE.config()).advanced.statusEffects, ((Config)ConfigHandler.CONFIG_STORE.config()).defaultValues);
        this.scoreboard = new BooleanComponent(((Config)ConfigHandler.CONFIG_STORE.config()).scoreboard.scoreboard, ((Config)ConfigHandler.CONFIG_STORE.config()).advanced.scoreboard, ((Config)ConfigHandler.CONFIG_STORE.config()).defaultValues);
        this.crosshair = new BooleanFadeOnlyComponent(((Config)ConfigHandler.CONFIG_STORE.config()).crosshair, ((Config)ConfigHandler.CONFIG_STORE.config()).advanced.crosshair, ((Config)ConfigHandler.CONFIG_STORE.config()).defaultValues);
        this.chat = new SimpleComponent(((Config)ConfigHandler.CONFIG_STORE.config()).chat.chat, ((Config)ConfigHandler.CONFIG_STORE.config()).advanced.chat, ((Config)ConfigHandler.CONFIG_STORE.config()).defaultValues);
        this.chatIndicator = new IComponent(new Config.IComponent(), ((Config)ConfigHandler.CONFIG_STORE.config()).advanced.chat, ((Config)ConfigHandler.CONFIG_STORE.config()).defaultValues){

            @Override
            public boolean active() {
                return ((Config)ConfigHandler.CONFIG_STORE.config()).chat.displayIndicator;
            }
        };
        this.actionBar = new SimpleComponent(((Config)ConfigHandler.CONFIG_STORE.config()).actionBar, ((Config)ConfigHandler.CONFIG_STORE.config()).advanced.actionBar, ((Config)ConfigHandler.CONFIG_STORE.config()).defaultValues);
        this.bossBar = new SimpleComponent(((Config)ConfigHandler.CONFIG_STORE.config()).bossBar, ((Config)ConfigHandler.CONFIG_STORE.config()).advanced.bossBar, ((Config)ConfigHandler.CONFIG_STORE.config()).defaultValues);
    }

    public static class PolicyComponent
    extends IComponent {
        private PolicyComponent(Config.PolicyComponent config, Config.AdvancedComponent values, Config.DefaultValues defaultValues) {
            super(config, values, defaultValues);
        }

        @Override
        public boolean active() {
            return this.policy() != RevealPolicy.Always;
        }

        @Override
        public boolean onChange() {
            return this.policy() != RevealPolicy.Always;
        }

        public RevealPolicy policy() {
            return ((Config.PolicyComponent)this.config).policy;
        }
    }

    public static class BooleanComponent
    extends IComponent {
        private BooleanComponent(Config.BooleanComponent config, Config.AdvancedComponent values, Config.DefaultValues defaultValues) {
            super(config, values, defaultValues);
        }

        @Override
        public boolean active() {
            return ((Config.BooleanComponent)this.config).active;
        }

        @Override
        public boolean onChange() {
            return ((Config.BooleanComponent)this.config).onChange;
        }
    }

    public static abstract class IComponent {
        Config.IComponent config;
        Config.AdvancedComponent values;
        Config.DefaultValues defaultValues;

        IComponent(Config.IComponent config, Config.AdvancedComponent values, Config.DefaultValues defaultValues) {
            this.config = config;
            this.values = values;
            this.defaultValues = defaultValues;
        }

        public abstract boolean active();

        public boolean onChange() {
            return false;
        }

        public ScrollDirection direction() {
            return this.values.direction;
        }

        public double speedMultiplier() {
            return this.values.speedMultiplier < 0.0 ? this.defaultValues.speedMultiplier : this.values.speedMultiplier;
        }

        public int distance() {
            return this.values.distance < 0 ? this.defaultValues.distance : this.values.distance;
        }

        public double maximumFade() {
            return this.values.maximumFade < 0.0 ? Math.min(this.defaultValues.maximumFade, 1.0) : Math.min(this.values.maximumFade, 1.0);
        }

        public boolean renderWhenHidden() {
            return this.values.renderWhenHidden;
        }
    }

    public static class BooleanFadeOnlyComponent
    extends IFadeOnlyComponent {
        private BooleanFadeOnlyComponent(Config.BooleanComponent config, Config.AdvancedFadeOnlyComponent values, Config.DefaultValues defaultValues) {
            super((Config.IComponent)config, values, defaultValues);
        }

        @Override
        public boolean active() {
            return ((Config.BooleanComponent)this.config).active;
        }

        @Override
        public boolean onChange() {
            return ((Config.BooleanComponent)this.config).onChange;
        }
    }

    public static class SimpleComponent
    extends IComponent {
        private SimpleComponent(Config.SimpleComponent config, Config.AdvancedComponent values, Config.DefaultValues defaultValues) {
            super(config, values, defaultValues);
        }

        @Override
        public boolean active() {
            return ((Config.SimpleComponent)this.config).active;
        }
    }

    private static class AutoHudConfigUpdater
    implements ConfigUpdater {
        private AutoHudConfigUpdater() {
        }

        public boolean updateConfigFile(JsonObject json) {
            if (json.has("revealHungerWhenHoldingFoodItem")) {
                boolean oldValue = json.get("revealHungerWhenHoldingFoodItem").getAsBoolean();
                json.remove("revealHungerWhenHoldingFoodItem");
                json.addProperty("revealBarsWhenHoldingConsumableItem", Boolean.valueOf(oldValue));
                return true;
            }
            return false;
        }
    }

    public static abstract class IFadeOnlyComponent
    extends IComponent {
        Config.AdvancedFadeOnlyComponent fadeOnlyValues;

        IFadeOnlyComponent(Config.IComponent config, Config.AdvancedFadeOnlyComponent values, Config.DefaultValues defaultValues) {
            super(config, new Config.AdvancedComponent(), defaultValues);
            this.fadeOnlyValues = values;
        }

        @Override
        public ScrollDirection direction() {
            return ScrollDirection.Up;
        }

        @Override
        public double speedMultiplier() {
            return this.fadeOnlyValues.speedMultiplier < 0.0 ? this.defaultValues.speedMultiplier : this.fadeOnlyValues.speedMultiplier;
        }

        @Override
        public int distance() {
            return 0;
        }

        @Override
        public double maximumFade() {
            return this.fadeOnlyValues.maximumFade < 0.0 ? Math.min(this.defaultValues.maximumFade, 1.0) : Math.min(this.fadeOnlyValues.maximumFade, 1.0);
        }
    }
}

