/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.mixin;

import mod.crend.autohud.AutoHud;
import mod.crend.autohud.render.AutoHudRenderer;
import mod.crend.autohud.render.ComponentRenderer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ForgeGui.class})
public class ForgeGuiMixin {
    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void autoHud$preRender(GuiGraphics context, float tickDelta, CallbackInfo ci) {
        AutoHudRenderer.inRender = true;
        AutoHudRenderer.tickDelta = tickDelta;
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void autoHud$postRender(GuiGraphics context, float tickDelta, CallbackInfo ci) {
        AutoHudRenderer.inRender = false;
    }

    @Inject(method={"renderHealth"}, at={@At(value="HEAD")})
    private void autoHud$preHealth(int width, int height, GuiGraphics context, CallbackInfo ci) {
        if (AutoHud.targetStatusBars) {
            ComponentRenderer.HEALTH.beginFade(context);
        }
    }

    @Inject(method={"renderArmor"}, at={@At(value="HEAD")})
    private void autoHud$preArmor(GuiGraphics context, int width, int height, CallbackInfo ci) {
        if (AutoHud.targetStatusBars) {
            ComponentRenderer.ARMOR.beginFade(context);
        }
    }

    @Inject(method={"renderFood"}, at={@At(value="HEAD")})
    private void autoHud$preFood(int width, int height, GuiGraphics context, CallbackInfo ci) {
        if (AutoHud.targetStatusBars) {
            ComponentRenderer.HUNGER.beginFade(context);
        }
    }

    @Inject(method={"renderAir"}, at={@At(value="HEAD")})
    private void autoHud$preAir(int width, int height, GuiGraphics context, CallbackInfo ci) {
        if (AutoHud.targetStatusBars) {
            ComponentRenderer.AIR.beginFade(context);
        }
    }

    @Inject(method={"renderHealthMount"}, at={@At(value="HEAD")})
    private void autoHud$preRenderHealthMount(int width, int height, GuiGraphics context, CallbackInfo ci) {
        if (AutoHud.targetStatusBars) {
            ComponentRenderer.MOUNT_HEALTH.beginFade(context);
        }
    }
}

