/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.concurrent.atomic.AtomicBoolean;
import mod.crend.autohud.AutoHud;
import mod.crend.autohud.component.Hud;
import mod.crend.autohud.render.AutoHudRenderer;
import mod.crend.autohud.render.ComponentRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.scores.Objective;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class}, priority=800)
public abstract class InGameHudMixin {
    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void autoHud$preRender(GuiGraphics context, float tickDelta, CallbackInfo ci) {
        AutoHudRenderer.startRender(context, tickDelta);
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void autoHud$postRender(GuiGraphics context, float tickDelta, CallbackInfo ci) {
        AutoHudRenderer.endRender();
    }

    @Inject(method={"renderHotbar"}, at={@At(value="HEAD")})
    private void autoHud$preHotbar(float tickDelta, GuiGraphics context, CallbackInfo ci) {
        ComponentRenderer.HOTBAR.beginFade(context);
    }

    @Inject(method={"renderHotbar"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;getMatrices()Lnet/minecraft/client/util/math/MatrixStack;", ordinal=0)})
    private void autoHud$hotbarTransparency(float tickDelta, GuiGraphics context, CallbackInfo ci) {
        AutoHudRenderer.injectTransparency();
    }

    @WrapOperation(method={"renderHotbar"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/hud/InGameHud;renderHotbarItem(Lnet/minecraft/client/gui/DrawContext;IIFLnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/item/ItemStack;I)V")})
    private void autoHud$transparentHotbarItems(Gui instance, GuiGraphics context, int x, int y, float tickDelta, Player player, ItemStack stack, int seed, Operation<Void> original) {
        ComponentRenderer.HOTBAR_ITEMS.wrap(context, () -> original.call(new Object[]{instance, context, x, y, Float.valueOf(tickDelta), player, stack, seed}));
    }

    @Inject(method={"renderHeldItemTooltip"}, at={@At(value="HEAD")})
    private void autoHud$preTooltip(GuiGraphics context, CallbackInfo ci) {
        ComponentRenderer.TOOLTIP.beginFade(context);
    }

    @Inject(method={"renderExperienceBar"}, at={@At(value="HEAD")})
    private void autoHud$preExperienceBar(GuiGraphics context, int x, CallbackInfo ci) {
        ComponentRenderer.EXPERIENCE_BAR_FORGE.beginFade(context);
    }

    @Inject(method={"renderExperienceBar"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiler/Profiler;push(Ljava/lang/String;)V", ordinal=1)})
    private void autoHud$experienceText(GuiGraphics context, int x, CallbackInfo ci) {
        ComponentRenderer.EXPERIENCE_LEVEL_FORGE.beginRender(context);
    }

    @Inject(method={"renderExperienceBar"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiler/Profiler;pop()V", ordinal=1)})
    private void autoHud$postExperienceText(GuiGraphics context, int x, CallbackInfo ci) {
        ComponentRenderer.EXPERIENCE_LEVEL_FORGE.endRender(context);
    }

    @Inject(method={"renderMountJumpBar"}, at={@At(value="HEAD")})
    private void autoHud$preMountJumpBar(PlayerRideableJumping mount, GuiGraphics context, int x, CallbackInfo ci) {
        ComponentRenderer.MOUNT_JUMP_BAR.beginFade(context);
    }

    @Inject(method={"renderScoreboardSidebar(Lnet/minecraft/client/gui/DrawContext;Lnet/minecraft/scoreboard/ScoreboardObjective;)V"}, at={@At(value="HEAD")})
    private void autoHud$preScoreboardSidebar(GuiGraphics context, Objective objective, CallbackInfo ci) {
        ComponentRenderer.SCOREBOARD.beginFade(context);
    }

    @WrapOperation(method={"renderCrosshair"}, slice={@Slice(from=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;blendFuncSeparate(Lcom/mojang/blaze3d/platform/GlStateManager$SrcFactor;Lcom/mojang/blaze3d/platform/GlStateManager$DstFactor;Lcom/mojang/blaze3d/platform/GlStateManager$SrcFactor;Lcom/mojang/blaze3d/platform/GlStateManager$DstFactor;)V"), to=@At(value="INVOKE", target="Lnet/minecraft/client/option/GameOptions;getAttackIndicator()Lnet/minecraft/client/option/SimpleOption;"))}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawTexture(Lnet/minecraft/util/Identifier;IIIIII)V")})
    private void autoHud$renderCrosshair(GuiGraphics context, ResourceLocation texture, int x, int y, int u, int v, int width, int height, Operation<Void> original) {
        ComponentRenderer.CROSSHAIR.wrap(context, () -> original.call(new Object[]{context, texture, x, y, u, v, width, height}), () -> original.call(new Object[]{context, texture, x, y, u, v, width, height}));
    }

    @WrapOperation(method={"renderStatusEffectOverlay"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/effect/StatusEffectInstance;shouldShowIcon()Z")})
    private boolean autoHud$shouldShowIcon(MobEffectInstance instance, Operation<Boolean> original, GuiGraphics context) {
        return ((Boolean)original.call(new Object[]{instance}) != false || AutoHud.config.showHiddenStatusEffects()) && Hud.shouldShowIcon(instance);
    }

    @WrapOperation(method={"renderStatusEffectOverlay"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawTexture(Lnet/minecraft/util/Identifier;IIIIII)V")})
    private void autoHud$wrapStatusEffect(GuiGraphics context, ResourceLocation texture, int x, int y, int u, int v, int width, int height, Operation<Void> original, @Local MobEffectInstance statusEffectInstance) {
        ComponentRenderer.getForStatusEffect(statusEffectInstance).wrap(context, () -> original.call(new Object[]{context, texture, x, y, u, v, width, height}));
    }

    @WrapOperation(require=0, method={"m_279741_", "method_18620"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawSprite(IIIIILnet/minecraft/client/texture/Sprite;)V")})
    private static void autoHud$wrapSprite(GuiGraphics context, int x, int y, int z, int width, int height, TextureAtlasSprite sprite, Operation<Void> original) {
        ComponentRenderer.getForStatusEffect(sprite).wrap(context, () -> original.call(new Object[]{context, x, y, z, width, height, sprite}));
    }

    @WrapOperation(method={"renderStatusEffectOverlay"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/client/extensions/common/IClientMobEffectExtensions;renderGuiIcon(Lnet/minecraft/entity/effect/StatusEffectInstance;Lnet/minecraft/client/gui/hud/InGameHud;Lnet/minecraft/client/gui/DrawContext;IIFF)Z")})
    private boolean autoHud$postEffect(IClientMobEffectExtensions instance, MobEffectInstance statusEffectInstance, Gui gui, GuiGraphics context, int x, int y, float z, float alpha, Operation<Boolean> original) {
        AtomicBoolean result = new AtomicBoolean();
        ComponentRenderer.getForStatusEffect(statusEffectInstance).wrap(context, () -> result.set((Boolean)original.call(new Object[]{instance, statusEffectInstance, gui, context, x, y, Float.valueOf(z), Float.valueOf(alpha)})));
        return result.get();
    }
}

