/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.mixin;

import mod.crend.autohud.component.ScoreboardHelper;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.Scoreboard;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Scoreboard.class})
public class ScoreboardMixin {
    @Inject(method={"updateExistingObjective"}, at={@At(value="HEAD")})
    public void autoHud$onObjectiveUpdate(Objective objective, CallbackInfo ci) {
        ScoreboardHelper.onObjectiveUpdate(objective);
    }

    @Inject(method={"updateScore"}, at={@At(value="HEAD")})
    public void autoHud$onPlayerScoreUpdate(Score score, CallbackInfo ci) {
        ScoreboardHelper.onPlayerScoreUpdate(score);
    }

    @Inject(method={"updatePlayerScore(Ljava/lang/String;)V"}, at={@At(value="HEAD")})
    public void autoHud$onPlayerScoreReset(String playerName, CallbackInfo ci) {
        ScoreboardHelper.onPlayerScoreRemove(playerName);
    }

    @Inject(method={"updatePlayerScore(Ljava/lang/String;Lnet/minecraft/scoreboard/ScoreboardObjective;)V"}, at={@At(value="HEAD")})
    public void autoHud$onPlayerScoreReset(String playerName, Objective objective, CallbackInfo ci) {
        ScoreboardHelper.onPlayerScoreRemove(playerName, objective);
    }

    @Inject(method={"addPlayerToTeam"}, at={@At(value="RETURN")})
    public void autoHud$onPlayerAddedToTeam(String playerName, PlayerTeam teamAddedTo, CallbackInfoReturnable<Boolean> ci) {
        ScoreboardHelper.onPlayerAddedToTeam(playerName, teamAddedTo);
    }

    @Inject(method={"removePlayerFromTeam"}, at={@At(value="TAIL")})
    public void autoHud$onPlayerRemovedFromTeam(String playerName, PlayerTeam teamRemovedFrom, CallbackInfo ci) {
        ScoreboardHelper.onPlayerRemovedFromTeam(playerName, teamRemovedFrom);
    }
}

