/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import mod.crend.autohud.AutoHud;
import mod.crend.autohud.render.ComponentRenderer;
import mod.crend.libbamboo.PlatformUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class}, priority=500)
public abstract class StatusEffectTimerMixin {
    @Shadow
    @Final
    private Minecraft f_92986_;

    @Inject(method={"renderStatusEffectOverlay"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", shift=At.Shift.AFTER)})
    private void appendOverlayDrawing(GuiGraphics context, CallbackInfo c, @Local List<Runnable> list, @Local MobEffectInstance statusEffectInstance, @Local(ordinal=2) int i2, @Local(ordinal=3) int i3, @Local(ordinal=4) int i4, @Local(ordinal=5) int i5) {
        list.add(() -> {
            if (AutoHud.config.statusEffectTimer()) {
                int x = switch (PlatformUtils.getCurrentPlatform()) {
                    default -> throw new IncompatibleClassChangeError();
                    case PlatformUtils.Platform.FABRIC -> i4;
                    case PlatformUtils.Platform.FORGE -> i5;
                    case PlatformUtils.Platform.NEOFORGE -> i2;
                };
                int y = switch (PlatformUtils.getCurrentPlatform()) {
                    default -> throw new IncompatibleClassChangeError();
                    case PlatformUtils.Platform.FABRIC -> i5;
                    case PlatformUtils.Platform.FORGE -> i3;
                    case PlatformUtils.Platform.NEOFORGE -> i3;
                };
                ComponentRenderer.getForStatusEffect(statusEffectInstance).wrap(context, () -> this.drawStatusEffectOverlay(context, statusEffectInstance, x, y));
            }
        });
    }

    @Unique
    private void drawStatusEffectOverlay(GuiGraphics context, MobEffectInstance statusEffectInstance, int x, int y) {
        String duration = this.getDurationAsString(statusEffectInstance);
        int durationLength = this.f_92986_.f_91062_.m_92895_(duration);
        context.m_280488_(this.f_92986_.f_91062_, duration, x + 13 - durationLength / 2, y + 14, -1711276033);
        int amplifier = statusEffectInstance.m_19564_();
        if (amplifier > 0) {
            String amplifierString = amplifier < 10 ? I18n.m_118938_((String)("enchantment.level." + (amplifier + 1)), (Object[])new Object[0]) : "**";
            int amplifierLength = this.f_92986_.f_91062_.m_92895_(amplifierString);
            context.m_280488_(this.f_92986_.f_91062_, amplifierString, x + 22 - amplifierLength, y + 3, -1711276033);
        }
    }

    @Unique
    private String getDurationAsString(MobEffectInstance statusEffectInstance) {
        if (statusEffectInstance.m_267577_()) {
            return I18n.m_118938_((String)"effect.duration.infinite", (Object[])new Object[0]);
        }
        int ticks = Mth.m_14143_((float)statusEffectInstance.m_19557_());
        int seconds = ticks / 20;
        if (seconds >= 3600) {
            return seconds / 3600 + "h";
        }
        if (seconds >= 60) {
            return seconds / 60 + "m";
        }
        return String.valueOf(seconds);
    }
}

