/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mod.crend.autohud.AutoHud;
import mod.crend.autohud.component.Component;
import mod.crend.autohud.component.Components;
import mod.crend.autohud.render.AutoHudRenderLayer;
import mod.crend.autohud.render.AutoHudRenderer;
import mod.crend.libbamboo.render.CustomFramebufferRenderer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;

public class ComponentRenderer {
    public static ComponentRenderer HOTBAR = ComponentRenderer.builder(Components.Hotbar).fade().move().doRender(() -> Components.Hotbar.shouldRender() || AutoHudRenderer.shouldRenderHotbarItems()).build();
    public static ComponentRenderer TOOLTIP = ComponentRenderer.of(Components.Tooltip);
    public static ComponentRenderer HOTBAR_ITEMS = ComponentRenderer.builder(Components.Hotbar).fade().isActive(() -> Components.Hotbar.isActive() && AutoHud.config.animationFade()).doRender(AutoHudRenderer::shouldRenderHotbarItems).withCustomFramebuffer(true).maximumFade(AutoHud.config::getHotbarItemsMaximumFade).beginRender((GuiGraphics context) -> AutoHudRenderLayer.FADE_MODE.postRender(Components.Hotbar, (GuiGraphics)context)).build();
    public static ComponentRenderer EXPERIENCE_BAR = ComponentRenderer.of(Components.ExperienceBar);
    public static ComponentRenderer EXPERIENCE_LEVEL = ComponentRenderer.of(Components.ExperienceLevel);
    public static ComponentRenderer EXPERIENCE_BAR_FORGE = ComponentRenderer.builder(Components.ExperienceBar).move().fade().doRender(() -> Components.ExperienceBar.shouldRender() || Components.ExperienceLevel.shouldRender()).build();
    public static ComponentRenderer EXPERIENCE_LEVEL_FORGE = ComponentRenderer.builder(Components.ExperienceLevel).move().fade().beginRender((GuiGraphics context) -> {
        AutoHudRenderLayer.MOVE_MODE.postRender(Components.ExperienceBar, (GuiGraphics)context);
        AutoHudRenderLayer.MOVE_MODE.preRender(Components.ExperienceLevel, (GuiGraphics)context);
    }).endRender((GuiGraphics context) -> {
        AutoHudRenderLayer.MOVE_MODE.postRender(Components.ExperienceLevel, (GuiGraphics)context);
        AutoHudRenderLayer.MOVE_MODE.preRender(Components.ExperienceBar, (GuiGraphics)context);
    }).build();
    public static ComponentRenderer ARMOR = ComponentRenderer.of(Components.Armor);
    public static ComponentRenderer ARMOR_FADE = ComponentRenderer.builder(Components.Armor).fade().withCustomFramebuffer(true).build();
    public static ComponentRenderer HEALTH = ComponentRenderer.of(Components.Health);
    public static ComponentRenderer HUNGER = ComponentRenderer.of(Components.Hunger);
    public static ComponentRenderer AIR = ComponentRenderer.of(Components.Air);
    public static ComponentRenderer MOUNT_HEALTH = ComponentRenderer.of(Components.MountHealth);
    public static ComponentRenderer MOUNT_JUMP_BAR = ComponentRenderer.of(Components.MountJumpBar);
    public static ComponentRenderer SCOREBOARD = ComponentRenderer.of(Components.Scoreboard);
    public static ComponentRenderer CROSSHAIR = ComponentRenderer.builder(Components.Crosshair).withCustomFramebuffer(false).beginRender((GuiGraphics context) -> {
        RenderSystem.defaultBlendFunc();
        AutoHudRenderLayer.FADE_MODE.preRender(Components.Crosshair, (GuiGraphics)context);
    }).endRender((GuiGraphics context) -> {
        AutoHudRenderLayer.FADE_MODE.postRender(Components.Crosshair, (GuiGraphics)context);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
    }).build();
    public static ComponentRenderer CHAT = ComponentRenderer.of(Components.Chat);
    public static ComponentRenderer BOSS_BAR = ComponentRenderer.of(Components.BossBar);
    public static ComponentRenderer ACTION_BAR = ComponentRenderer.of(Components.ActionBar);
    public static ComponentRenderer CHAT_MESSAGE_INDICATOR = ComponentRenderer.of(Components.ChatIndicator);
    static Map<ResourceLocation, ComponentRenderer> statusEffectComponents = new HashMap<ResourceLocation, ComponentRenderer>();
    private final Component component;
    private final Supplier<Boolean> isActive;
    private final Supplier<Boolean> doRender;
    private final Consumer<GuiGraphics> beginRender;
    private final Consumer<GuiGraphics> endRender;

    public static void registerStatusEffectComponent(Component component) {
        statusEffectComponents.put(component.identifier, ComponentRenderer.of(component));
    }

    public static ComponentRenderer getForStatusEffect(MobEffectInstance instance) {
        return statusEffectComponents.get(Component.get((MobEffect)instance.m_19544_()).identifier);
    }

    public static ComponentRenderer getForStatusEffect(TextureAtlasSprite sprite) {
        return statusEffectComponents.get(Objects.requireNonNull(Component.findBySprite((TextureAtlasSprite)sprite)).identifier);
    }

    public static Builder builder(Component component) {
        return new Builder(component);
    }

    public static ComponentRenderer of(Component component) {
        return ComponentRenderer.builder(component).move().fade().build();
    }

    private ComponentRenderer(Component component, Supplier<Boolean> isActive, Supplier<Boolean> doRender, Consumer<GuiGraphics> beginRender, Consumer<GuiGraphics> endRender) {
        this.component = component;
        this.isActive = isActive;
        this.doRender = doRender;
        this.beginRender = beginRender;
        this.endRender = endRender;
    }

    public boolean isActive() {
        return this.isActive.get();
    }

    public boolean doRender() {
        return this.doRender.get();
    }

    public void beginRender(GuiGraphics context) {
        if (this.isActive()) {
            this.beginRender.accept(context);
        }
    }

    public void endRender(GuiGraphics context) {
        if (this.isActive()) {
            this.endRender.accept(context);
        }
    }

    public void wrap(GuiGraphics context, Runnable originalRenderCall) {
        this.wrap(context, originalRenderCall, originalRenderCall);
    }

    public void wrap(GuiGraphics context, Runnable customRenderCall, Runnable originalRenderCall) {
        if (this.isActive()) {
            if (this.doRender()) {
                this.beginRender.accept(context);
                customRenderCall.run();
                this.endRender.accept(context);
            }
        } else {
            originalRenderCall.run();
        }
    }

    public void wrap(GuiGraphics context, Consumer<GuiGraphics> originalRenderCall) {
        this.wrap(context, originalRenderCall, originalRenderCall);
    }

    public void wrap(GuiGraphics context, Consumer<GuiGraphics> customRenderCall, Consumer<GuiGraphics> originalRenderCall) {
        this.wrap(context, () -> customRenderCall.accept(context), () -> originalRenderCall.accept(context));
    }

    public void beginFade(GuiGraphics context) {
        if (this.isActive()) {
            AutoHudRenderLayer.FADE_MODE.preRender(this.component, context);
        }
    }

    public void endFade(GuiGraphics context) {
        if (this.isActive()) {
            AutoHudRenderLayer.FADE_MODE.postRender(this.component, context);
        }
    }

    public static class Builder {
        private final Component component;
        private boolean fade = false;
        private boolean move = false;
        private boolean customFramebuffer = false;
        private boolean containedInMovedComponent = false;
        private Supplier<Float> maximumFade = null;
        private Supplier<Boolean> isActive = null;
        private Supplier<Boolean> doRender = null;
        private Consumer<GuiGraphics> beginRender = null;
        private Consumer<GuiGraphics> endRender = null;

        Builder(Component component) {
            this.component = component;
        }

        public Builder fade() {
            this.fade = true;
            return this;
        }

        public Builder move() {
            this.move = true;
            return this;
        }

        public Builder withCustomFramebuffer(boolean containedInMovedComponent) {
            this.customFramebuffer = true;
            this.containedInMovedComponent = containedInMovedComponent;
            return this;
        }

        public Builder maximumFade(Supplier<Float> maximumFade) {
            this.maximumFade = maximumFade;
            return this;
        }

        public Builder isActive(Supplier<Boolean> isActive) {
            this.isActive = isActive;
            return this;
        }

        public Builder doRender(Supplier<Boolean> doRender) {
            this.doRender = doRender;
            return this;
        }

        public Builder beginRender(Consumer<GuiGraphics> beginRender) {
            this.beginRender = beginRender;
            return this;
        }

        public Builder endRender(Consumer<GuiGraphics> endRender) {
            this.endRender = endRender;
            return this;
        }

        public ComponentRenderer build() {
            if (this.isActive == null) {
                this.isActive = this.component::isActive;
            }
            if (this.doRender == null) {
                this.doRender = this.component::shouldRender;
            }
            if (this.maximumFade == null) {
                this.maximumFade = () -> Float.valueOf((float)this.component.config.maximumFade());
            }
            AutoHudRenderLayer wrapper = this.move || !this.fade ? AutoHudRenderLayer.MOVE_MODE : AutoHudRenderLayer.FADE_MODE;
            if (this.beginRender == null) {
                this.beginRender = context -> wrapper.preRender(this.component, (GuiGraphics)context, this.maximumFade.get().floatValue());
            }
            if (this.endRender == null) {
                this.endRender = context -> wrapper.postRender(this.component, (GuiGraphics)context);
            }
            return new ComponentRenderer(this.component, this.isActive, this.doRender, this.customFramebuffer ? context -> {
                this.beginRender.accept((GuiGraphics)context);
                CustomFramebufferRenderer.init();
            } : this.beginRender, this.customFramebuffer ? this.getCustomFramebufferEndRender() : this.endRender);
        }

        private Consumer<GuiGraphics> getCustomFramebufferEndRender() {
            if (this.fade) {
                if (this.containedInMovedComponent) {
                    return context -> {
                        this.endRender.accept((GuiGraphics)context);
                        AutoHudRenderLayer.FADE_MODE_WITH_REVERSE_TRANSLATION.wrap(this.component, (GuiGraphics)context, this.maximumFade.get().floatValue(), () -> CustomFramebufferRenderer.draw((GuiGraphics)context));
                    };
                }
                return context -> {
                    this.endRender.accept((GuiGraphics)context);
                    AutoHudRenderLayer.FADE_MODE.wrap(this.component, (GuiGraphics)context, this.maximumFade.get().floatValue(), () -> CustomFramebufferRenderer.draw((GuiGraphics)context));
                };
            }
            return context -> {
                this.endRender.accept((GuiGraphics)context);
                CustomFramebufferRenderer.draw((GuiGraphics)context);
            };
        }
    }
}

