/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.mixin.render;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.Heightmap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import pigcart.particlerain.StonecutterUtil;
import pigcart.particlerain.WeatherParticleManager;
import pigcart.particlerain.config.ModConfig;

@Mixin(value={LevelRenderer.class})
public class WeatherEffectRendererMixin {
    @WrapOperation(method={"tickRain"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/LevelReader;getBiome(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/core/Holder;")})
    public Holder<Biome> getBiomeValue(LevelReader instance, BlockPos pos, Operation<Holder<Biome>> original) {
        return Minecraft.m_91087_().f_91073_.m_9598_().m_175515_(Registries.f_256952_).m_246971_(Biomes.f_48202_);
    }

    @Inject(method={"tickRain"}, at={@At(value="FIELD", opcode=181, shift=At.Shift.AFTER, ordinal=1, target="Lnet/minecraft/client/renderer/LevelRenderer;rainSoundTime:I")}, cancellable=true)
    public void doAdditionalWeatherSounds(Camera camera, CallbackInfo ci, @Local(ordinal=0) BlockPos blockPos, @Local(ordinal=1) BlockPos blockPos2) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (blockPos2.m_123342_() > blockPos.m_123342_() + 1 && level.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockPos).m_123342_() > Mth.m_14143_((float)blockPos.m_123342_())) {
            SoundEvent sound = WeatherParticleManager.getAdditionalWeatherSounds(level, blockPos2, true);
            if (sound != null) {
                level.m_245747_(blockPos2, sound, SoundSource.WEATHER, 0.1f, 0.5f, false);
            }
        } else {
            SoundEvent sound = WeatherParticleManager.getAdditionalWeatherSounds(level, blockPos2, false);
            if (sound != null) {
                level.m_245747_(blockPos2, sound, SoundSource.WEATHER, 0.2f, 1.0f, false);
            }
        }
        if (!ModConfig.CONFIG.sound.doRainSounds || !StonecutterUtil.getPrecipitationAt((Level)level, (Biome)level.m_204166_(blockPos2).m_203334_(), blockPos2).equals((Object)Biome.Precipitation.RAIN)) {
            ci.cancel();
        }
    }

    @WrapOperation(method={"tickRain"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/OptionInstance;get()Ljava/lang/Object;")})
    public Object optionsParticlesGet(OptionInstance instance, Operation<ParticleStatus> original) {
        if (!ModConfig.CONFIG.compat.doDefaultSplashing) {
            return ParticleStatus.MINIMAL;
        }
        return original.call(new Object[]{instance});
    }

    @Inject(method={"renderSnowAndRain"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(LightTexture lightTexture, float partialTick, double camX, double camY, double camZ, CallbackInfo ci) {
        if (!ModConfig.CONFIG.compat.renderDefaultWeather) {
            ci.cancel();
        }
    }
}

