/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.event;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import fuzs.puzzleslib.api.core.v1.ModContainerHelper;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.event.v1.LoadCompleteCallback;
import fuzs.puzzleslib.api.event.v1.RegistryEntryAddedCallback;
import fuzs.puzzleslib.api.event.v1.core.EventInvoker;
import fuzs.puzzleslib.api.event.v1.core.EventPhase;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.event.v1.core.ForgeEventInvokerRegistry;
import fuzs.puzzleslib.api.event.v1.data.DefaultedDouble;
import fuzs.puzzleslib.api.event.v1.data.DefaultedFloat;
import fuzs.puzzleslib.api.event.v1.data.DefaultedInt;
import fuzs.puzzleslib.api.event.v1.data.DefaultedValue;
import fuzs.puzzleslib.api.event.v1.data.MutableDouble;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import fuzs.puzzleslib.api.event.v1.data.MutableValue;
import fuzs.puzzleslib.api.event.v1.entity.EntityRidingEvents;
import fuzs.puzzleslib.api.event.v1.entity.ProjectileImpactCallback;
import fuzs.puzzleslib.api.event.v1.entity.ServerEntityLevelEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.AnimalTameCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.BabyEntitySpawnCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.CheckMobDespawnCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.ItemAttributeModifiersCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingAttackCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingChangeTargetCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingConversionCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDeathCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDropsCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingEquipmentChangeCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingExperienceDropCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingFallCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingHurtCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingKnockBackCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LootingLevelCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.MobEffectEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.ShieldBlockCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.UseItemEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.AnvilRepairCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.AnvilUpdateCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.ArrowLooseCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.BonemealCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.GrindstoneEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.ItemTossCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.ItemTouchCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerInteractEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerTickEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerXpEvents;
import fuzs.puzzleslib.api.event.v1.level.BlockEvents;
import fuzs.puzzleslib.api.event.v1.level.ExplosionEvents;
import fuzs.puzzleslib.api.event.v1.level.GatherPotentialSpawnsCallback;
import fuzs.puzzleslib.api.event.v1.level.PlayLevelSoundEvents;
import fuzs.puzzleslib.api.event.v1.level.ServerChunkEvents;
import fuzs.puzzleslib.api.event.v1.level.ServerLevelEvents;
import fuzs.puzzleslib.api.event.v1.level.ServerLevelTickEvents;
import fuzs.puzzleslib.api.event.v1.server.LootTableLoadEvents;
import fuzs.puzzleslib.api.event.v1.server.RegisterCommandsCallback;
import fuzs.puzzleslib.api.event.v1.server.ServerLifecycleEvents;
import fuzs.puzzleslib.api.event.v1.server.ServerTickEvents;
import fuzs.puzzleslib.api.event.v1.server.SyncDataPackContentsCallback;
import fuzs.puzzleslib.api.event.v1.server.TagsUpdatedCallback;
import fuzs.puzzleslib.api.init.v3.RegistryHelper;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.client.event.ForgeClientEventInvokers;
import fuzs.puzzleslib.impl.event.EventImplHelper;
import fuzs.puzzleslib.impl.event.ForgeAttributeModifiersMultimap;
import fuzs.puzzleslib.impl.event.LootTableModifyEvent;
import fuzs.puzzleslib.impl.event.PotentialSpawnsList;
import fuzs.puzzleslib.impl.event.core.EventInvokerImpl;
import fuzs.puzzleslib.mixin.accessor.ForgeRegistryForgeAccessor;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.GrindstoneEvent;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.PlayLevelSoundEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.ChunkWatchEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.IModBusEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.jetbrains.annotations.Nullable;

public final class ForgeEventInvokerRegistryImpl
implements ForgeEventInvokerRegistry {
    public static void registerLoadingHandlers() {
        INSTANCE.register(LoadCompleteCallback.class, FMLLoadCompleteEvent.class, (T callback, E evt) -> callback.onLoadComplete());
        INSTANCE.register(RegistryEntryAddedCallback.class, ForgeEventInvokerRegistryImpl::onRegistryEntryAdded);
        if (ModLoaderEnvironment.INSTANCE.isClient()) {
            ForgeClientEventInvokers.registerLoadingHandlers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void onRegistryEntryAdded(RegistryEntryAddedCallback<T> callback, @Nullable Object context) {
        Objects.requireNonNull(context, "context is null");
        ResourceKey resourceKey = (ResourceKey)context;
        Registry registry = RegistryHelper.findBuiltInRegistry(resourceKey);
        ForgeRegistry forgeRegistry = RegistryManager.ACTIVE.getRegistry(resourceKey);
        boolean[] loadComplete = new boolean[1];
        ForgeRegistry forgeRegistry2 = forgeRegistry;
        synchronized (forgeRegistry2) {
            IForgeRegistry.AddCallback originalAddCallback = ((ForgeRegistryForgeAccessor)forgeRegistry).puzzleslib$getAdd();
            IForgeRegistry.AddCallback newAddCallback = (owner, stage, id, key, obj, oldObj) -> {
                if (loadComplete[0] || oldObj != null) {
                    return;
                }
                try {
                    callback.onRegistryEntryAdded(registry, key.m_135782_(), obj, (resourceLocation, supplier) -> {
                        try {
                            Object t = supplier.get();
                            Objects.requireNonNull(t, "entry is null");
                            owner.register(resourceLocation, t);
                        }
                        catch (Exception exception) {
                            PuzzlesLib.LOGGER.error("Failed to register new entry", (Throwable)exception);
                        }
                    });
                }
                catch (Exception exception) {
                    PuzzlesLib.LOGGER.error("Failed to run registry entry added callback", (Throwable)exception);
                }
            };
            ((ForgeRegistryForgeAccessor)forgeRegistry).puzzleslib$setAdd(originalAddCallback != null ? (owner, stage, id, key, obj, oldObj) -> {
                originalAddCallback.onAdd(owner, stage, id, key, obj, oldObj);
                newAddCallback.onAdd(owner, stage, id, key, obj, oldObj);
            } : newAddCallback);
        }
        IEventBus eventBus = ModContainerHelper.getActiveModEventBus();
        eventBus.addListener(evt -> {
            loadComplete[0] = true;
        });
        LinkedHashSet callbacks = Sets.newLinkedHashSet();
        for (Map.Entry entry : forgeRegistry.getEntries()) {
            callbacks.add(consumer -> {
                try {
                    callback.onRegistryEntryAdded(registry, ((ResourceKey)entry.getKey()).m_135782_(), (Object)entry.getValue(), (BiConsumer)consumer);
                }
                catch (Exception exception) {
                    PuzzlesLib.LOGGER.error("Failed to run registry entry added callback", (Throwable)exception);
                }
            });
        }
        eventBus.addListener(evt -> {
            if (evt.getRegistryKey() != resourceKey) {
                return;
            }
            callbacks.forEach(consumer -> consumer.accept((resourceLocation, supplier) -> evt.register(resourceKey, resourceLocation, supplier)));
            callbacks.clear();
        });
    }

    public static void registerEventHandlers() {
        INSTANCE.register(PlayerInteractEvents.UseBlock.class, PlayerInteractEvent.RightClickBlock.class, (T callback, E evt) -> {
            EventResultHolder<InteractionResult> result = callback.onUseBlock(evt.getEntity(), evt.getLevel(), evt.getHand(), evt.getHitVec());
            Optional<InteractionResult> optional = result.getInterrupt().filter(t -> t != InteractionResult.PASS);
            if (optional.isPresent()) {
                evt.setCancellationResult(optional.get());
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(PlayerInteractEvents.AttackBlock.class, PlayerInteractEvent.LeftClickBlock.class, (T callback, E evt) -> {
            EventResultHolder<InteractionResult> result = callback.onAttackBlock(evt.getEntity(), evt.getLevel(), evt.getHand(), evt.getPos(), evt.getFace());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(PlayerInteractEvents.AttackBlockV2.class, PlayerInteractEvent.LeftClickBlock.class, (T callback, E evt) -> {
            EventResult result = callback.onAttackBlock(evt.getEntity(), evt.getLevel(), evt.getHand(), evt.getPos(), evt.getFace());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(PlayerInteractEvents.UseItem.class, PlayerInteractEvent.RightClickItem.class, (T callback, E evt) -> {
            InteractionResultHolder<ItemStack> holder;
            EventResultHolder<InteractionResultHolder<ItemStack>> result = callback.onUseItem(evt.getEntity(), evt.getLevel(), evt.getHand());
            if (result.isInterrupt() && (holder = result.getInterrupt().get()).m_19089_() != InteractionResult.PASS) {
                evt.setCancellationResult(holder.m_19089_());
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(PlayerInteractEvents.UseItemV2.class, PlayerInteractEvent.RightClickItem.class, (T callback, E evt) -> {
            InteractionResult interactionResult;
            EventResultHolder<InteractionResult> result = callback.onUseItem(evt.getEntity(), evt.getLevel(), evt.getHand());
            if (result.isInterrupt() && (interactionResult = result.getInterrupt().get()) != InteractionResult.PASS) {
                evt.setCancellationResult(interactionResult);
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(PlayerInteractEvents.UseEntity.class, PlayerInteractEvent.EntityInteract.class, (T callback, E evt) -> {
            InteractionResult interactionResult;
            EventResultHolder<InteractionResult> result = callback.onUseEntity(evt.getEntity(), evt.getLevel(), evt.getHand(), evt.getTarget());
            if (result.isInterrupt() && (interactionResult = result.getInterrupt().get()) != InteractionResult.PASS) {
                evt.setCancellationResult(interactionResult);
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(PlayerInteractEvents.UseEntityAt.class, PlayerInteractEvent.EntityInteractSpecific.class, (T callback, E evt) -> {
            InteractionResult interactionResult;
            EventResultHolder<InteractionResult> result = callback.onUseEntityAt(evt.getEntity(), evt.getLevel(), evt.getHand(), evt.getTarget(), evt.getLocalPos());
            if (result.isInterrupt() && (interactionResult = result.getInterrupt().get()) != InteractionResult.PASS) {
                evt.setCancellationResult(interactionResult);
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(PlayerInteractEvents.AttackEntity.class, AttackEntityEvent.class, (T callback, E evt) -> {
            if (callback.onAttackEntity(evt.getEntity(), evt.getEntity().m_9236_(), InteractionHand.MAIN_HAND, evt.getTarget()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(PlayerXpEvents.PickupXp.class, PlayerXpEvent.PickupXp.class, (T callback, E evt) -> {
            if (callback.onPickupXp(evt.getEntity(), evt.getOrb()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(BonemealCallback.class, BonemealEvent.class, (T callback, E evt) -> {
            EventResult result = callback.onBonemeal(evt.getLevel(), evt.getPos(), evt.getBlock(), evt.getStack());
            if (result.isInterrupt()) {
                if (result.getAsBoolean()) {
                    evt.setResult(Event.Result.ALLOW);
                } else {
                    evt.setCanceled(true);
                }
            }
        });
        INSTANCE.register(LivingExperienceDropCallback.class, LivingExperienceDropEvent.class, (T callback, E evt) -> {
            DefaultedInt droppedExperience = DefaultedInt.fromEvent(arg_0 -> ((LivingExperienceDropEvent)evt).setDroppedExperience(arg_0), () -> ((LivingExperienceDropEvent)evt).getDroppedExperience(), () -> ((LivingExperienceDropEvent)evt).getOriginalExperience());
            if (callback.onLivingExperienceDrop(evt.getEntity(), evt.getAttackingPlayer(), droppedExperience).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(BlockEvents.Break.class, BlockEvent.BreakEvent.class, (T callback, E evt) -> {
            LevelAccessor patt15288$temp = evt.getLevel();
            if (!(patt15288$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt15288$temp;
            Player patt15367$temp = evt.getPlayer();
            if (!(patt15367$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt15367$temp;
            if (evt.getState().m_60734_() instanceof GameMasterBlock && !evt.getPlayer().m_36337_()) {
                return;
            }
            GameType gameType = serverPlayer.f_8941_.m_9290_();
            if (evt.getPlayer().m_36187_((Level)evt.getLevel(), evt.getPos(), gameType)) {
                return;
            }
            EventResult result = callback.onBreakBlock(serverLevel, evt.getPos(), evt.getState(), evt.getPlayer(), evt.getPlayer().m_21205_());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(BlockEvents.DropExperience.class, BlockEvent.BreakEvent.class, (T callback, E evt) -> {
            MutableInt experienceToDrop = MutableInt.fromEvent(arg_0 -> ((BlockEvent.BreakEvent)evt).setExpToDrop(arg_0), () -> ((BlockEvent.BreakEvent)evt).getExpToDrop());
            callback.onDropExperience((ServerLevel)evt.getLevel(), evt.getPos(), evt.getState(), evt.getPlayer(), evt.getPlayer().m_21205_(), experienceToDrop);
        });
        INSTANCE.register(BlockEvents.FarmlandTrample.class, BlockEvent.FarmlandTrampleEvent.class, (T callback, E evt) -> {
            LevelAccessor patt16842$temp = evt.getLevel();
            if (!(patt16842$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt16842$temp;
            if (callback.onFarmlandTrample((Level)serverLevel, evt.getPos(), evt.getState(), evt.getFallDistance(), evt.getEntity()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(PlayerTickEvents.Start.class, TickEvent.PlayerTickEvent.class, (T callback, E evt) -> {
            if (evt.phase != TickEvent.Phase.START) {
                return;
            }
            callback.onStartPlayerTick(evt.player);
        });
        INSTANCE.register(PlayerTickEvents.End.class, TickEvent.PlayerTickEvent.class, (T callback, E evt) -> {
            if (evt.phase != TickEvent.Phase.END) {
                return;
            }
            callback.onEndPlayerTick(evt.player);
        });
        INSTANCE.register(LivingFallCallback.class, LivingFallEvent.class, (T callback, E evt) -> {
            MutableFloat fallDistance = MutableFloat.fromEvent(arg_0 -> ((LivingFallEvent)evt).setDistance(arg_0), () -> ((LivingFallEvent)evt).getDistance());
            MutableFloat damageMultiplier = MutableFloat.fromEvent(arg_0 -> ((LivingFallEvent)evt).setDamageMultiplier(arg_0), () -> ((LivingFallEvent)evt).getDamageMultiplier());
            if (callback.onLivingFall(evt.getEntity(), fallDistance, damageMultiplier).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(RegisterCommandsCallback.class, RegisterCommandsEvent.class, (T callback, E evt) -> callback.onRegisterCommands((CommandDispatcher<CommandSourceStack>)evt.getDispatcher(), evt.getBuildContext(), evt.getCommandSelection()));
        INSTANCE.register(LootTableLoadEvents.Replace.class, LootTableLoadEvent.class, (T callback, E evt) -> {
            MutableValue<LootTable> table = MutableValue.fromEvent(arg_0 -> ((LootTableLoadEvent)evt).setTable(arg_0), () -> ((LootTableLoadEvent)evt).getTable());
            callback.onReplaceLootTable(evt.getName(), table);
        });
        INSTANCE.register(LootTableLoadEvents.Modify.class, LootTableModifyEvent.class, (T callback, E evt) -> callback.onModifyLootTable(evt.getLootDataManager(), evt.getIdentifier(), evt::addPool, evt::removePool));
        INSTANCE.register(AnvilRepairCallback.class, AnvilRepairEvent.class, (T callback, E evt) -> {
            MutableFloat breakChance = MutableFloat.fromEvent(arg_0 -> ((AnvilRepairEvent)evt).setBreakChance(arg_0), () -> ((AnvilRepairEvent)evt).getBreakChance());
            callback.onAnvilRepair(evt.getEntity(), evt.getLeft(), evt.getRight(), evt.getOutput(), breakChance);
        });
        INSTANCE.register(ItemTouchCallback.class, EntityItemPickupEvent.class, (T callback, E evt) -> {
            EventResult result = callback.onItemTouch(evt.getEntity(), evt.getItem());
            if (result.isInterrupt()) {
                if (result.getAsBoolean()) {
                    evt.setResult(Event.Result.ALLOW);
                } else {
                    evt.setCanceled(true);
                }
            }
        });
        INSTANCE.register(PlayerEvents.ItemPickup.class, PlayerEvent.ItemPickupEvent.class, (T callback, E evt) -> callback.onItemPickup(evt.getEntity(), evt.getOriginalEntity(), evt.getStack()));
        INSTANCE.register(LootingLevelCallback.class, LootingLevelEvent.class, (T callback, E evt) -> {
            MutableInt lootingLevel = MutableInt.fromEvent(arg_0 -> ((LootingLevelEvent)evt).setLootingLevel(arg_0), () -> ((LootingLevelEvent)evt).getLootingLevel());
            callback.onLootingLevel(evt.getEntity(), evt.getDamageSource(), lootingLevel);
        });
        INSTANCE.register(AnvilUpdateCallback.class, AnvilUpdateEvent.class, (T callback, E evt) -> {
            ItemStack originalOutput = evt.getOutput();
            int originalEnchantmentCost = evt.getCost();
            int originalMaterialCost = evt.getMaterialCost();
            MutableValue<ItemStack> output = MutableValue.fromEvent(arg_0 -> ((AnvilUpdateEvent)evt).setOutput(arg_0), () -> ((AnvilUpdateEvent)evt).getOutput());
            MutableInt enchantmentCost = MutableInt.fromEvent(arg_0 -> ((AnvilUpdateEvent)evt).setCost(arg_0), () -> ((AnvilUpdateEvent)evt).getCost());
            MutableInt materialCost = MutableInt.fromEvent(arg_0 -> ((AnvilUpdateEvent)evt).setMaterialCost(arg_0), () -> ((AnvilUpdateEvent)evt).getMaterialCost());
            EventResult result = callback.onAnvilUpdate(evt.getLeft(), evt.getRight(), output, evt.getName(), enchantmentCost, materialCost, evt.getPlayer());
            if (result.isInterrupt()) {
                if (!result.getAsBoolean()) {
                    evt.setCanceled(true);
                }
            } else {
                evt.setOutput(originalOutput);
                evt.setCost(originalEnchantmentCost);
                evt.setMaterialCost(originalMaterialCost);
            }
        });
        INSTANCE.register(LivingDropsCallback.class, LivingDropsEvent.class, (T callback, E evt) -> {
            if (callback.onLivingDrops(evt.getEntity(), evt.getSource(), evt.getDrops(), evt.getLootingLevel(), evt.isRecentlyHit()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(LivingEvents.Tick.class, LivingEvent.LivingTickEvent.class, (T callback, E evt) -> {
            if (callback.onLivingTick(evt.getEntity()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(ArrowLooseCallback.class, ArrowLooseEvent.class, (T callback, E evt) -> {
            MutableInt charge = MutableInt.fromEvent(arg_0 -> ((ArrowLooseEvent)evt).setCharge(arg_0), () -> ((ArrowLooseEvent)evt).getCharge());
            if (callback.onArrowLoose(evt.getEntity(), evt.getBow(), evt.getLevel(), charge, evt.hasAmmo()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(LivingHurtCallback.class, LivingHurtEvent.class, (T callback, E evt) -> {
            MutableFloat amount = MutableFloat.fromEvent(arg_0 -> ((LivingHurtEvent)evt).setAmount(arg_0), () -> ((LivingHurtEvent)evt).getAmount());
            if (callback.onLivingHurt(evt.getEntity(), evt.getSource(), amount).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(UseItemEvents.Start.class, LivingEntityUseItemEvent.Start.class, (T callback, E evt) -> {
            MutableInt useDuration = MutableInt.fromEvent(arg_0 -> ((LivingEntityUseItemEvent.Start)evt).setDuration(arg_0), () -> ((LivingEntityUseItemEvent.Start)evt).getDuration());
            if (callback.onUseItemStart(evt.getEntity(), evt.getItem(), useDuration).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(UseItemEvents.Tick.class, LivingEntityUseItemEvent.Tick.class, (T callback, E evt) -> {
            MutableInt useItemRemaining = MutableInt.fromEvent(arg_0 -> ((LivingEntityUseItemEvent.Tick)evt).setDuration(arg_0), () -> ((LivingEntityUseItemEvent.Tick)evt).getDuration());
            if (callback.onUseItemTick(evt.getEntity(), evt.getItem(), useItemRemaining).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(UseItemEvents.Stop.class, LivingEntityUseItemEvent.Stop.class, (T callback, E evt) -> {
            if (callback.onUseItemStop(evt.getEntity(), evt.getItem(), evt.getDuration()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(UseItemEvents.Finish.class, LivingEntityUseItemEvent.Finish.class, (T callback, E evt) -> {
            MutableValue<ItemStack> stack = MutableValue.fromEvent(arg_0 -> ((LivingEntityUseItemEvent.Finish)evt).setResultStack(arg_0), () -> ((LivingEntityUseItemEvent.Finish)evt).getResultStack());
            callback.onUseItemFinish(evt.getEntity(), stack, evt.getDuration(), evt.getItem());
        });
        INSTANCE.register(ShieldBlockCallback.class, ShieldBlockEvent.class, (T callback, E evt) -> {
            DefaultedFloat blockedDamage = DefaultedFloat.fromEvent(arg_0 -> ((ShieldBlockEvent)evt).setBlockedDamage(arg_0), () -> ((ShieldBlockEvent)evt).getBlockedDamage(), () -> ((ShieldBlockEvent)evt).getOriginalBlockedDamage());
            if (callback.onShieldBlock(evt.getEntity(), evt.getDamageSource(), blockedDamage).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(TagsUpdatedCallback.class, TagsUpdatedEvent.class, (T callback, E evt) -> callback.onTagsUpdated(evt.getRegistryAccess(), evt.getUpdateCause() == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED));
        INSTANCE.register(ExplosionEvents.Start.class, ExplosionEvent.Start.class, (T callback, E evt) -> {
            if (callback.onExplosionStart(evt.getLevel(), evt.getExplosion()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(ExplosionEvents.Detonate.class, ExplosionEvent.Detonate.class, (T callback, E evt) -> callback.onExplosionDetonate(evt.getLevel(), evt.getExplosion(), evt.getAffectedBlocks(), evt.getAffectedEntities()));
        INSTANCE.register(SyncDataPackContentsCallback.class, OnDatapackSyncEvent.class, (T callback, E evt) -> {
            if (evt.getPlayer() != null) {
                callback.onSyncDataPackContents(evt.getPlayer(), true);
                return;
            }
            for (ServerPlayer player : evt.getPlayerList().m_11314_()) {
                callback.onSyncDataPackContents(player, false);
            }
        });
        INSTANCE.register(ServerLifecycleEvents.ServerStarting.class, ServerAboutToStartEvent.class, (T callback, E evt) -> callback.onServerStarting(evt.getServer()));
        INSTANCE.register(ServerLifecycleEvents.ServerStarted.class, ServerStartedEvent.class, (T callback, E evt) -> callback.onServerStarted(evt.getServer()));
        INSTANCE.register(ServerLifecycleEvents.ServerStopping.class, ServerStoppingEvent.class, (T callback, E evt) -> callback.onServerStopping(evt.getServer()));
        INSTANCE.register(ServerLifecycleEvents.ServerStopped.class, ServerStoppedEvent.class, (T callback, E evt) -> callback.onServerStopped(evt.getServer()));
        INSTANCE.register(PlayLevelSoundEvents.AtPosition.class, PlayLevelSoundEvent.AtPosition.class, (T callback, E evt) -> {
            MutableValue<Holder<SoundEvent>> sound = MutableValue.fromEvent(arg_0 -> ((PlayLevelSoundEvent.AtPosition)evt).setSound(arg_0), () -> ((PlayLevelSoundEvent.AtPosition)evt).getSound());
            MutableValue<SoundSource> source = MutableValue.fromEvent(arg_0 -> ((PlayLevelSoundEvent.AtPosition)evt).setSource(arg_0), () -> ((PlayLevelSoundEvent.AtPosition)evt).getSource());
            DefaultedFloat volume = DefaultedFloat.fromEvent(arg_0 -> ((PlayLevelSoundEvent.AtPosition)evt).setNewVolume(arg_0), () -> ((PlayLevelSoundEvent.AtPosition)evt).getNewVolume(), () -> ((PlayLevelSoundEvent.AtPosition)evt).getOriginalVolume());
            DefaultedFloat pitch = DefaultedFloat.fromEvent(arg_0 -> ((PlayLevelSoundEvent.AtPosition)evt).setNewPitch(arg_0), () -> ((PlayLevelSoundEvent.AtPosition)evt).getNewPitch(), () -> ((PlayLevelSoundEvent.AtPosition)evt).getOriginalPitch());
            if (callback.onPlaySoundAtPosition(evt.getLevel(), evt.getPosition(), sound, source, volume, pitch).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(PlayLevelSoundEvents.AtEntity.class, PlayLevelSoundEvent.AtEntity.class, (T callback, E evt) -> {
            MutableValue<Holder<SoundEvent>> sound = MutableValue.fromEvent(arg_0 -> ((PlayLevelSoundEvent.AtEntity)evt).setSound(arg_0), () -> ((PlayLevelSoundEvent.AtEntity)evt).getSound());
            MutableValue<SoundSource> source = MutableValue.fromEvent(arg_0 -> ((PlayLevelSoundEvent.AtEntity)evt).setSource(arg_0), () -> ((PlayLevelSoundEvent.AtEntity)evt).getSource());
            DefaultedFloat volume = DefaultedFloat.fromEvent(arg_0 -> ((PlayLevelSoundEvent.AtEntity)evt).setNewVolume(arg_0), () -> ((PlayLevelSoundEvent.AtEntity)evt).getNewVolume(), () -> ((PlayLevelSoundEvent.AtEntity)evt).getOriginalVolume());
            DefaultedFloat pitch = DefaultedFloat.fromEvent(arg_0 -> ((PlayLevelSoundEvent.AtEntity)evt).setNewPitch(arg_0), () -> ((PlayLevelSoundEvent.AtEntity)evt).getNewPitch(), () -> ((PlayLevelSoundEvent.AtEntity)evt).getOriginalPitch());
            if (callback.onPlaySoundAtEntity(evt.getLevel(), evt.getEntity(), sound, source, volume, pitch).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(ServerEntityLevelEvents.Load.class, EntityJoinLevelEvent.class, (T callback, E evt) -> {
            MobSpawnType mobSpawnType;
            Entity patt29864$temp;
            Level patt29690$temp = evt.getLevel();
            if (!(patt29690$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt29690$temp;
            Entity entity = evt.getEntity();
            if (!evt.loadedFromDisk() && (patt29864$temp = evt.getEntity()) instanceof Mob) {
                Mob mob = (Mob)patt29864$temp;
                mobSpawnType = mob.getSpawnType();
            } else {
                mobSpawnType = null;
            }
            if (callback.onEntityLoad(entity, serverLevel, mobSpawnType).isInterrupt()) {
                if (evt.getEntity() instanceof Player) {
                    throw new UnsupportedOperationException("Cannot prevent player from spawning in!");
                }
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(ServerEntityLevelEvents.LoadV2.class, EntityJoinLevelEvent.class, (T callback, E evt) -> {
            Level patt30525$temp = evt.getLevel();
            if (!(patt30525$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt30525$temp;
            if (callback.onEntityLoad(evt.getEntity(), serverLevel).isInterrupt()) {
                if (evt.getEntity() instanceof Player) {
                    throw new UnsupportedOperationException("Cannot prevent player from loading in!");
                }
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(ServerEntityLevelEvents.Spawn.class, EntityJoinLevelEvent.class, (T callback, E evt) -> {
            MobSpawnType mobSpawnType;
            Entity patt31423$temp;
            ServerLevel serverLevel;
            block8: {
                block7: {
                    Level patt31249$temp = evt.getLevel();
                    if (!(patt31249$temp instanceof ServerLevel)) break block7;
                    serverLevel = (ServerLevel)patt31249$temp;
                    if (!evt.loadedFromDisk()) break block8;
                }
                return;
            }
            Entity entity = patt31423$temp = evt.getEntity();
            if (patt31423$temp instanceof Mob) {
                Mob mob = (Mob)patt31423$temp;
                mobSpawnType = mob.getSpawnType();
            } else {
                mobSpawnType = null;
            }
            if (callback.onEntitySpawn(entity, serverLevel, mobSpawnType).isInterrupt()) {
                if (evt.getEntity() instanceof Player) {
                    throw new UnsupportedOperationException("Cannot prevent player from spawning in!");
                }
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(ServerEntityLevelEvents.Remove.class, EntityLeaveLevelEvent.class, (T callback, E evt) -> {
            Level patt32087$temp = evt.getLevel();
            if (!(patt32087$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt32087$temp;
            callback.onEntityRemove(evt.getEntity(), serverLevel);
        });
        INSTANCE.register(LivingDeathCallback.class, LivingDeathEvent.class, (T callback, E evt) -> {
            EventResult result = callback.onLivingDeath(evt.getEntity(), evt.getSource());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(PlayerEvents.StartTracking.class, PlayerEvent.StartTracking.class, (T callback, E evt) -> {
            Player patt32711$temp = evt.getEntity();
            if (!(patt32711$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt32711$temp;
            callback.onStartTracking(evt.getTarget(), serverPlayer);
        });
        INSTANCE.register(PlayerEvents.StopTracking.class, PlayerEvent.StopTracking.class, (T callback, E evt) -> {
            Player patt33036$temp = evt.getEntity();
            if (!(patt33036$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt33036$temp;
            callback.onStopTracking(evt.getTarget(), serverPlayer);
        });
        INSTANCE.register(PlayerEvents.LoggedIn.class, PlayerEvent.PlayerLoggedInEvent.class, (T callback, E evt) -> {
            Player patt33366$temp = evt.getEntity();
            if (!(patt33366$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt33366$temp;
            callback.onLoggedIn(serverPlayer);
        });
        INSTANCE.register(PlayerEvents.LoggedOut.class, PlayerEvent.PlayerLoggedOutEvent.class, (T callback, E evt) -> {
            Player patt33679$temp = evt.getEntity();
            if (!(patt33679$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt33679$temp;
            callback.onLoggedOut(serverPlayer);
        });
        INSTANCE.register(PlayerEvents.AfterChangeDimension.class, PlayerEvent.PlayerChangedDimensionEvent.class, (T callback, E evt) -> {
            Player patt34029$temp = evt.getEntity();
            if (!(patt34029$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt34029$temp;
            ServerLevel from = serverPlayer.m_20194_().m_129880_(evt.getFrom());
            ServerLevel to = serverPlayer.m_20194_().m_129880_(evt.getTo());
            Objects.requireNonNull(from, "level origin is null");
            Objects.requireNonNull(to, "level destination is null");
            callback.onAfterChangeDimension(serverPlayer, from, to);
        });
        INSTANCE.register(BabyEntitySpawnCallback.class, BabyEntitySpawnEvent.class, (T callback, E evt) -> {
            MutableValue<AgeableMob> child = MutableValue.fromEvent(arg_0 -> ((BabyEntitySpawnEvent)evt).setChild(arg_0), () -> ((BabyEntitySpawnEvent)evt).getChild());
            if (callback.onBabyEntitySpawn(evt.getParentA(), evt.getParentB(), child).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(AnimalTameCallback.class, AnimalTameEvent.class, (T callback, E evt) -> {
            if (callback.onAnimalTame(evt.getAnimal(), evt.getTamer()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(LivingAttackCallback.class, LivingAttackEvent.class, (T callback, E evt) -> {
            if (callback.onLivingAttack(evt.getEntity(), evt.getSource(), evt.getAmount()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(PlayerEvents.Copy.class, PlayerEvent.Clone.class, (T callback, E evt) -> {
            Player patt35633$temp = evt.getOriginal();
            if (!(patt35633$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer originalServerPlayer = (ServerPlayer)patt35633$temp;
            Player patt35722$temp = evt.getEntity();
            if (!(patt35722$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer newServerPlayer = (ServerPlayer)patt35722$temp;
            evt.getOriginal().reviveCaps();
            callback.onCopy(originalServerPlayer, newServerPlayer, !evt.isWasDeath());
            evt.getOriginal().invalidateCaps();
        });
        INSTANCE.register(PlayerEvents.Respawn.class, PlayerEvent.PlayerRespawnEvent.class, (T callback, E evt) -> {
            Player patt36162$temp = evt.getEntity();
            if (!(patt36162$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt36162$temp;
            callback.onRespawn(serverPlayer, evt.isEndConquered());
        });
        INSTANCE.register(ServerTickEvents.Start.class, TickEvent.ServerTickEvent.class, (T callback, E evt) -> {
            if (evt.phase != TickEvent.Phase.START) {
                return;
            }
            callback.onStartServerTick(evt.getServer());
        });
        INSTANCE.register(ServerTickEvents.End.class, TickEvent.ServerTickEvent.class, (T callback, E evt) -> {
            if (evt.phase != TickEvent.Phase.END) {
                return;
            }
            callback.onEndServerTick(evt.getServer());
        });
        INSTANCE.register(ServerLevelTickEvents.Start.class, TickEvent.LevelTickEvent.class, (T callback, E evt) -> {
            Level patt37090$temp;
            if (evt.phase != TickEvent.Phase.START || !((patt37090$temp = evt.level) instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt37090$temp;
            callback.onStartLevelTick(level.m_7654_(), level);
        });
        INSTANCE.register(ServerLevelTickEvents.End.class, TickEvent.LevelTickEvent.class, (T callback, E evt) -> {
            Level patt37433$temp;
            if (evt.phase != TickEvent.Phase.END || !((patt37433$temp = evt.level) instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt37433$temp;
            callback.onEndLevelTick(level.m_7654_(), level);
        });
        INSTANCE.register(ServerLevelEvents.Load.class, LevelEvent.Load.class, (T callback, E evt) -> {
            LevelAccessor patt37719$temp = evt.getLevel();
            if (!(patt37719$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt37719$temp;
            callback.onLevelLoad(level.m_7654_(), level);
        });
        INSTANCE.register(ServerLevelEvents.Unload.class, LevelEvent.Unload.class, (T callback, E evt) -> {
            LevelAccessor patt38010$temp = evt.getLevel();
            if (!(patt38010$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt38010$temp;
            callback.onLevelUnload(level.m_7654_(), level);
        });
        INSTANCE.register(ServerChunkEvents.Load.class, ChunkEvent.Load.class, (T callback, E evt) -> {
            LevelAccessor patt38295$temp = evt.getLevel();
            if (!(patt38295$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt38295$temp;
            callback.onChunkLoad(level, (LevelChunk)evt.getChunk());
        });
        INSTANCE.register(ServerChunkEvents.Unload.class, ChunkEvent.Unload.class, (T callback, E evt) -> {
            LevelAccessor patt38596$temp = evt.getLevel();
            if (!(patt38596$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt38596$temp;
            callback.onChunkUnload(level, (LevelChunk)evt.getChunk());
        });
        INSTANCE.register(ItemTossCallback.class, ItemTossEvent.class, (T callback, E evt) -> {
            if (callback.onItemToss(evt.getEntity(), evt.getPlayer()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(LivingKnockBackCallback.class, LivingKnockBackEvent.class, (T callback, E evt) -> {
            DefaultedDouble strength = DefaultedDouble.fromEvent(v -> evt.setStrength((float)v), () -> ((LivingKnockBackEvent)evt).getStrength(), () -> ((LivingKnockBackEvent)evt).getOriginalStrength());
            DefaultedDouble ratioX = DefaultedDouble.fromEvent(arg_0 -> ((LivingKnockBackEvent)evt).setRatioX(arg_0), () -> ((LivingKnockBackEvent)evt).getRatioX(), () -> ((LivingKnockBackEvent)evt).getOriginalRatioX());
            DefaultedDouble ratioZ = DefaultedDouble.fromEvent(arg_0 -> ((LivingKnockBackEvent)evt).setRatioZ(arg_0), () -> ((LivingKnockBackEvent)evt).getRatioZ(), () -> ((LivingKnockBackEvent)evt).getOriginalRatioZ());
            if (callback.onLivingKnockBack(evt.getEntity(), strength, ratioX, ratioZ).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(ItemAttributeModifiersCallback.class, ItemAttributeModifierEvent.class, (T callback, E evt) -> {
            ForgeAttributeModifiersMultimap attributeModifiers = new ForgeAttributeModifiersMultimap(() -> ((ItemAttributeModifierEvent)evt).getModifiers(), (arg_0, arg_1) -> ((ItemAttributeModifierEvent)evt).addModifier(arg_0, arg_1), (arg_0, arg_1) -> ((ItemAttributeModifierEvent)evt).removeModifier(arg_0, arg_1), arg_0 -> ((ItemAttributeModifierEvent)evt).removeAttribute(arg_0), () -> ((ItemAttributeModifierEvent)evt).clearModifiers());
            callback.onItemAttributeModifiers(evt.getItemStack(), evt.getSlotType(), (Multimap<Attribute, AttributeModifier>)attributeModifiers);
        });
        INSTANCE.register(ProjectileImpactCallback.class, ProjectileImpactEvent.class, (T callback, E evt) -> {
            if (callback.onProjectileImpact(evt.getProjectile(), evt.getRayTraceResult()).isInterrupt()) {
                evt.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
            }
        });
        INSTANCE.register(PlayerEvents.BreakSpeed.class, PlayerEvent.BreakSpeed.class, (T callback, E evt) -> {
            DefaultedFloat breakSpeed = DefaultedFloat.fromEvent(arg_0 -> ((PlayerEvent.BreakSpeed)evt).setNewSpeed(arg_0), () -> ((PlayerEvent.BreakSpeed)evt).getNewSpeed(), () -> ((PlayerEvent.BreakSpeed)evt).getOriginalSpeed());
            if (callback.onBreakSpeed(evt.getEntity(), evt.getState(), breakSpeed).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(MobEffectEvents.Affects.class, MobEffectEvent.Applicable.class, (T callback, E evt) -> {
            EventResult result = callback.onMobEffectAffects(evt.getEntity(), evt.getEffectInstance());
            if (result.isInterrupt()) {
                evt.setResult(result.getAsBoolean() ? Event.Result.ALLOW : Event.Result.DENY);
            }
        });
        INSTANCE.register(MobEffectEvents.Apply.class, MobEffectEvent.Added.class, (T callback, E evt) -> callback.onMobEffectApply(evt.getEntity(), evt.getEffectInstance(), evt.getOldEffectInstance(), evt.getEffectSource()));
        INSTANCE.register(MobEffectEvents.Remove.class, MobEffectEvent.Remove.class, (T callback, E evt) -> {
            if (callback.onMobEffectRemove(evt.getEntity(), evt.getEffectInstance()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(MobEffectEvents.Expire.class, MobEffectEvent.Expired.class, (T callback, E evt) -> callback.onMobEffectExpire(evt.getEntity(), evt.getEffectInstance()));
        INSTANCE.register(LivingEvents.Jump.class, LivingEvent.LivingJumpEvent.class, (T callback, E evt) -> EventImplHelper.onLivingJump(callback, evt.getEntity()));
        INSTANCE.register(LivingEvents.Visibility.class, LivingEvent.LivingVisibilityEvent.class, (T callback, E evt) -> callback.onLivingVisibility(evt.getEntity(), evt.getLookingEntity(), MutableDouble.fromEvent(visibilityModifier -> evt.modifyVisibility(visibilityModifier / evt.getVisibilityModifier()), () -> ((LivingEvent.LivingVisibilityEvent)evt).getVisibilityModifier())));
        INSTANCE.register(LivingChangeTargetCallback.class, LivingChangeTargetEvent.class, (T callback, E evt) -> {
            DefaultedValue<LivingEntity> target = DefaultedValue.fromEvent(arg_0 -> ((LivingChangeTargetEvent)evt).setNewTarget(arg_0), () -> ((LivingChangeTargetEvent)evt).getNewTarget(), () -> ((LivingChangeTargetEvent)evt).getOriginalTarget());
            if (callback.onLivingChangeTarget(evt.getEntity(), target).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(CheckMobDespawnCallback.class, MobSpawnEvent.AllowDespawn.class, (T callback, E evt) -> {
            ServerLevelAccessor patt43636$temp = evt.getLevel();
            if (!(patt43636$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt43636$temp;
            EventResult result = callback.onCheckMobDespawn(evt.getEntity(), serverLevel);
            if (result.isInterrupt()) {
                evt.setResult(result.getAsBoolean() ? Event.Result.ALLOW : Event.Result.DENY);
            }
        });
        INSTANCE.register(GatherPotentialSpawnsCallback.class, LevelEvent.PotentialSpawns.class, (T callback, E evt) -> {
            LevelAccessor patt44141$temp = evt.getLevel();
            if (!(patt44141$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt44141$temp;
            PotentialSpawnsList<MobSpawnSettings.SpawnerData> mobsAt = new PotentialSpawnsList<MobSpawnSettings.SpawnerData>(() -> ((LevelEvent.PotentialSpawns)evt).getSpawnerDataList(), spawnerData -> {
                evt.addSpawnerData(spawnerData);
                return true;
            }, arg_0 -> ((LevelEvent.PotentialSpawns)evt).removeSpawnerData(arg_0));
            callback.onGatherPotentialSpawns(serverLevel, serverLevel.m_215010_(), serverLevel.m_7726_().m_8481_(), evt.getMobCategory(), evt.getPos(), mobsAt);
        });
        INSTANCE.register(EntityRidingEvents.Start.class, EntityMountEvent.class, (T callback, E evt) -> {
            if (evt.isDismounting()) {
                return;
            }
            if (callback.onStartRiding(evt.getLevel(), evt.getEntity(), evt.getEntityBeingMounted()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(EntityRidingEvents.Stop.class, EntityMountEvent.class, (T callback, E evt) -> {
            if (evt.isMounting()) {
                return;
            }
            if (callback.onStopRiding(evt.getLevel(), evt.getEntity(), evt.getEntityBeingMounted()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(GrindstoneEvents.Update.class, GrindstoneEvent.OnPlaceItem.class, (T callback, E evt) -> {
            ItemStack originalOutput = evt.getOutput();
            int originalExperienceReward = evt.getXp();
            MutableValue<ItemStack> output = MutableValue.fromEvent(arg_0 -> ((GrindstoneEvent.OnPlaceItem)evt).setOutput(arg_0), () -> ((GrindstoneEvent.OnPlaceItem)evt).getOutput());
            MutableInt experienceReward = MutableInt.fromEvent(arg_0 -> ((GrindstoneEvent.OnPlaceItem)evt).setXp(arg_0), () -> ((GrindstoneEvent.OnPlaceItem)evt).getXp());
            Player player = EventImplHelper.getGrindstoneUsingPlayer(evt.getTopItem(), evt.getBottomItem()).orElseThrow(NullPointerException::new);
            EventResult result = callback.onGrindstoneUpdate(evt.getTopItem(), evt.getBottomItem(), output, experienceReward, player);
            if (result.isInterrupt()) {
                if (!result.getAsBoolean()) {
                    evt.setCanceled(true);
                }
            } else {
                evt.setOutput(originalOutput);
                evt.setXp(originalExperienceReward);
            }
        });
        INSTANCE.register(GrindstoneEvents.Use.class, GrindstoneEvent.OnTakeItem.class, (T callback, E evt) -> {
            DefaultedValue<ItemStack> topInput = DefaultedValue.fromValue(evt.getTopItem());
            if (!evt.getNewTopItem().m_41619_()) {
                topInput.accept(evt.getNewTopItem());
            }
            DefaultedValue<ItemStack> bottomInput = DefaultedValue.fromValue(evt.getBottomItem());
            if (!evt.getNewBottomItem().m_41619_()) {
                bottomInput.accept(evt.getNewBottomItem());
            }
            Player player = EventImplHelper.getGrindstoneUsingPlayer(evt.getTopItem(), evt.getBottomItem()).orElseThrow(NullPointerException::new);
            callback.onGrindstoneUse(topInput, bottomInput, player);
            topInput.getAsOptional().ifPresent(arg_0 -> ((GrindstoneEvent.OnTakeItem)evt).setNewTopItem(arg_0));
            bottomInput.getAsOptional().ifPresent(arg_0 -> ((GrindstoneEvent.OnTakeItem)evt).setNewBottomItem(arg_0));
        });
        INSTANCE.register(ServerChunkEvents.Watch.class, ChunkWatchEvent.Watch.class, (T callback, E evt) -> callback.onChunkWatch(evt.getPlayer(), evt.getChunk(), evt.getLevel()));
        INSTANCE.register(ServerChunkEvents.Unwatch.class, ChunkWatchEvent.UnWatch.class, (T callback, E evt) -> callback.onChunkUnwatch(evt.getPlayer(), evt.getPos(), evt.getLevel()));
        INSTANCE.register(LivingEquipmentChangeCallback.class, LivingEquipmentChangeEvent.class, (T callback, E evt) -> callback.onLivingEquipmentChange(evt.getEntity(), evt.getSlot(), evt.getFrom(), evt.getTo()));
        INSTANCE.register(LivingConversionCallback.class, LivingConversionEvent.Post.class, (T callback, E evt) -> callback.onLivingConversion(evt.getEntity(), evt.getOutcome()));
        if (ModLoaderEnvironment.INSTANCE.isClient()) {
            ForgeClientEventInvokers.register();
        }
    }

    @Override
    public <T, E extends Event> void register(Class<T> clazz, Class<E> event, ForgeEventInvokerRegistry.ForgeEventContextConsumer<T, E> converter, boolean joinInvokers) {
        FMLJavaModLoadingContext context;
        Objects.requireNonNull(clazz, "type is null");
        Objects.requireNonNull(converter, "converter is null");
        IEventBus eventBus = IModBusEvent.class.isAssignableFrom(event) ? ((context = FMLJavaModLoadingContext.get()) != null ? context.getModEventBus() : null) : MinecraftForge.EVENT_BUS;
        EventInvokerImpl.register(clazz, new ForgeEventInvoker<T, E>(eventBus, event, converter), joinInvokers);
    }

    private record ForgeEventInvoker<T, E extends Event>(@Nullable IEventBus eventBus, Class<E> event, ForgeEventInvokerRegistry.ForgeEventContextConsumer<T, E> converter) implements EventInvoker<T>,
    EventInvokerImpl.EventInvokerLike<T>
    {
        private static final Map<EventPhase, EventPriority> PHASE_TO_PRIORITY = Map.of(EventPhase.FIRST, EventPriority.HIGHEST, EventPhase.BEFORE, EventPriority.HIGH, EventPhase.DEFAULT, EventPriority.NORMAL, EventPhase.AFTER, EventPriority.LOW, EventPhase.LAST, EventPriority.LOWEST);

        @Override
        public EventInvoker<T> asEventInvoker(@Nullable Object context) {
            return context != null ? (phase, callback) -> this.register(phase, callback, context) : this;
        }

        @Override
        public void register(EventPhase phase, T callback) {
            this.register(phase, callback, null);
        }

        private void register(EventPhase phase, T callback, @Nullable Object context) {
            Objects.requireNonNull(phase, "phase is null");
            Objects.requireNonNull(callback, "callback is null");
            EventPriority eventPriority = PHASE_TO_PRIORITY.getOrDefault(phase, EventPriority.NORMAL);
            IEventBus eventBus = this.eventBus;
            if (eventBus == null) {
                Objects.requireNonNull(context, "mod id context is null");
                eventBus = ModContainerHelper.getModEventBus((String)context);
            }
            if (eventBus != MinecraftForge.EVENT_BUS && eventPriority != EventPriority.NORMAL) {
                throw new IllegalStateException("mod event bus does not support event phases");
            }
            eventBus.addListener(eventPriority, false, this.event, evt -> this.converter.accept(callback, (Event)evt, context));
        }
    }
}

