/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.seamless_loading_screen;

import com.minenash.seamless_loading_screen.DisplayMode;
import com.minenash.seamless_loading_screen.ScreenshotLoader;
import com.minenash.seamless_loading_screen.config.Config;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.Util;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.Screenshot;
import org.slf4j.Logger;

public class OnLeaveHelper {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static boolean attemptScreenShot = false;
    public static Runnable onceFinished = () -> {};
    private static int old_FrameBufferWidth = 0;
    private static int old_FrameBufferHeight = 0;

    public static void beginScreenshotTask(Runnable runnable) {
        if (ScreenshotLoader.displayMode == DisplayMode.FREEZE) {
            runnable.run();
            return;
        }
        attemptScreenShot = true;
        onceFinished = runnable;
        Options options = Minecraft.m_91087_().f_91066_;
        options.m_92157_(CameraType.FIRST_PERSON);
        options.f_92063_ = false;
        options.f_92064_ = false;
        options.f_92065_ = false;
        Window window = Minecraft.m_91087_().m_91268_();
        old_FrameBufferWidth = window.m_85441_();
        old_FrameBufferHeight = window.m_85442_();
        window.m_166450_(Config.get().resolution.width);
        window.m_166452_(Config.get().resolution.height);
        Minecraft.m_91087_().m_5741_();
    }

    public static void takeScreenShot() {
        Minecraft client = Minecraft.m_91087_();
        String name = ScreenshotLoader.getFileName();
        NativeImage nativeImage = Screenshot.m_92279_((RenderTarget)client.m_91385_());
        try {
            File file = new File(name);
            if (!file.exists()) {
                file.createNewFile();
            }
            nativeImage.m_85056_(new File(name));
            if (Config.get().archiveScreenshots) {
                String fileName = "screenshots/worlds/archive/" + name.substring(name.lastIndexOf("/"), name.length() - 4) + "_" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + ".png";
                File archiveFile = new File(fileName);
                if (!archiveFile.exists()) {
                    archiveFile.createNewFile();
                }
                nativeImage.m_85056_(archiveFile);
            }
        }
        catch (IOException e) {
            LOGGER.error("[SeamlessLoadingScreen]: Unable to take a screenshot on leaving of a world, such will not be saved! [Name: {}]", (Object)name);
            LOGGER.error(e.toString());
        }
        if (Config.get().updateWorldIcon && client.m_91090_()) {
            OnLeaveHelper.updateIcon(((Path)client.m_91092_().m_182649_().get()).toFile(), nativeImage);
        }
        attemptScreenShot = false;
        Window window = Minecraft.m_91087_().m_91268_();
        window.m_166450_(old_FrameBufferWidth);
        window.m_166452_(old_FrameBufferHeight);
        client.m_5741_();
        onceFinished.run();
        onceFinished = () -> {};
    }

    private static void updateIcon(File iconFile, NativeImage nativeImage) {
        Util.m_183992_().execute(() -> {
            int i = nativeImage.m_84982_();
            int j = nativeImage.m_85084_();
            int k = 0;
            int l = 0;
            if (i > j) {
                k = (i - j) / 2;
                i = j;
            } else {
                l = (j - i) / 2;
                j = i;
            }
            try (NativeImage nativeImage2 = new NativeImage(64, 64, false);){
                nativeImage.m_85034_(k, l, i, j, nativeImage2);
                nativeImage2.m_85056_(iconFile);
            }
            catch (IOException e) {
                LOGGER.error("[SeamlessLoadingScreen] Unable to update the world icon!", (Throwable)e);
            }
            finally {
                nativeImage.close();
            }
        });
    }
}

