/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.seamless_loading_screen.mixin.custom_screenshots;

import com.minenash.seamless_loading_screen.DisplayMode;
import com.minenash.seamless_loading_screen.ServerInfoExtension;
import com.minenash.seamless_loading_screen.config.Config;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.nbt.CompoundTag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerData.class})
public class ServerInfoMixin
implements ServerInfoExtension {
    @Shadow
    public String f_105363_;
    @Unique
    private DisplayMode displayMode = DisplayMode.ENABLED;

    @Inject(method={"toNbt"}, at={@At(value="RETURN")})
    private void serialize(CallbackInfoReturnable<CompoundTag> callback) {
        ((CompoundTag)callback.getReturnValue()).m_128359_("screenshotDisplayMode", this.displayMode.toString());
    }

    @Inject(method={"fromNbt"}, at={@At(value="RETURN")})
    private static void deserialize(CompoundTag tag, CallbackInfoReturnable<ServerData> callback) {
        if (!tag.m_128425_("screenshotDisplayMode", 8)) {
            return;
        }
        ((ServerInfoMixin)callback.getReturnValue()).displayMode = Enum.valueOf(DisplayMode.class, tag.m_128461_("screenshotDisplayMode"));
    }

    @Inject(method={"copyFrom"}, at={@At(value="TAIL")})
    private void copyFrom(ServerData info, CallbackInfo callback) {
        this.displayMode = ((ServerInfoMixin)info).displayMode;
    }

    @Override
    public void setDisplayMode(DisplayMode mode) {
        this.displayMode = mode;
    }

    @Override
    public DisplayMode getDisplayMode() {
        for (String blacklistedAddress : Config.get().blacklistedAddresses) {
            if (!this.f_105363_.contains(blacklistedAddress)) continue;
            return DisplayMode.DISABLED;
        }
        return this.displayMode;
    }
}

